/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.checker;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.checker.TypeCheckerTypingConstraints;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;

public class JetTypeChecker {
    public static final JetTypeChecker DEFAULT = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerTypingConstraints()));
    public static final JetTypeChecker FLEXIBLE_UNEQUAL_TO_INFLEXIBLE = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerTypingConstraints()){

        @Override
        protected boolean heterogeneousEquivalence(JetType inflexibleType, JetType flexibleType) {
            return false;
        }
    });
    private final TypeCheckingProcedure procedure;

    @NotNull
    public static JetTypeChecker withAxioms(final @NotNull TypeConstructorEquality equalityAxioms) {
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "withAxioms"));
        }
        JetTypeChecker jetTypeChecker = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerTypingConstraints(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (constructor1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor1", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$2", "assertEqualTypeConstructors"));
                }
                if (constructor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor2", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$2", "assertEqualTypeConstructors"));
                }
                return constructor1.equals(constructor2) || equalityAxioms.equals(constructor1, constructor2);
            }
        }));
        if (jetTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "withAxioms"));
        }
        return jetTypeChecker;
    }

    private JetTypeChecker(@NotNull TypeCheckingProcedure procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "<init>"));
        }
        this.procedure = procedure;
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        return this.procedure.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        return this.procedure.equalTypes(a, b);
    }

    public static interface TypeConstructorEquality {
        public boolean equals(@NotNull TypeConstructor var1, @NotNull TypeConstructor var2);
    }
}

