/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeCapability;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public abstract class AbstractJetType
implements JetType {
    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        if (capabilityClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/jet/lang/types/AbstractJetType", "getCapability"));
        }
        if (capabilityClass.isInstance(this)) {
            return (T)((TypeCapability)((Object)this));
        }
        return null;
    }

    public final int hashCode() {
        int result2 = this.getConstructor().hashCode();
        result2 = 31 * result2 + ((Object)this.getArguments()).hashCode();
        result2 = 31 * result2 + (this.isNullable() ? 1 : 0);
        return result2;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JetType)) {
            return false;
        }
        JetType type2 = (JetType)obj;
        return this.isNullable() == type2.isNullable() && JetTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(this, type2);
    }

    public String toString() {
        List<TypeProjection> arguments2 = this.getArguments();
        return this.getConstructor() + (arguments2.isEmpty() ? "" : "<" + AbstractJetType.argumentsToString(arguments2) + ">") + (this.isNullable() ? "?" : "");
    }

    private static StringBuilder argumentsToString(List<TypeProjection> arguments2) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<TypeProjection> iterator2 = arguments2.iterator();
        while (iterator2.hasNext()) {
            TypeProjection argument = iterator2.next();
            stringBuilder.append(argument);
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }
}

