/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class FqNameBase {
    protected FqNameBase() {
        if (!(this instanceof FqName) && !(this instanceof FqNameUnsafe)) {
            throw new AssertionError((Object)"do not use this class directly");
        }
    }

    @NotNull
    protected abstract String asString();

    @NotNull
    private FqNameUnsafe toFqNameUnsafe() {
        if (this instanceof FqName) {
            FqNameUnsafe fqNameUnsafe = ((FqName)this).toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqNameBase", "toFqNameUnsafe"));
            }
            return fqNameUnsafe;
        }
        if (this instanceof FqNameUnsafe) {
            FqNameUnsafe fqNameUnsafe = (FqNameUnsafe)this;
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqNameBase", "toFqNameUnsafe"));
            }
            return fqNameUnsafe;
        }
        throw new AssertionError();
    }

    public final boolean equalsTo(@Nullable FqName that) {
        return that != null && this.equalsTo(that.toUnsafe());
    }

    public final boolean equalsTo(@Nullable FqNameUnsafe that) {
        return this.toFqNameUnsafe().equals(that);
    }

    @NotNull
    public abstract Name shortNameOrSpecial();

    @NotNull
    public abstract List<Name> pathSegments();
}

