/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.ScriptBodyResolver;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.data.JetScriptInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.storage.ExceptionTracker;
import org.jetbrains.jet.storage.LazyResolveStorageManager;
import org.jetbrains.jet.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;

public class ResolveSession
implements KotlinCodeAnalyzer {
    private final LazyResolveStorageManager storageManager;
    private final ExceptionTracker exceptionTracker;
    private final ModuleDescriptor module;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final MemoizedFunctionToNullable<FqName, LazyPackageDescriptor> packages;
    private final PackageFragmentProvider packageFragmentProvider;
    private final MemoizedFunctionToNotNull<JetScript, LazyScriptDescriptor> scriptDescriptors;
    private final MemoizedFunctionToNotNull<JetFile, LazyAnnotations> annotations;
    private ScopeProvider scopeProvider;
    private JetImportsFactory jetImportFactory;
    private AnnotationResolver annotationResolve;
    private DescriptorResolver descriptorResolver;
    private TypeResolver typeResolver;
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    private ScriptBodyResolver scriptBodyResolver;

    @Inject
    public void setJetImportFactory(JetImportsFactory jetImportFactory) {
        this.jetImportFactory = jetImportFactory;
    }

    @Inject
    public void setAnnotationResolve(AnnotationResolver annotationResolve) {
        this.annotationResolve = annotationResolve;
    }

    @Inject
    public void setDescriptorResolver(DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setQualifiedExpressionResolver(QualifiedExpressionResolver qualifiedExpressionResolver) {
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    @Inject
    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    @Inject
    public void setScriptBodyResolver(ScriptBodyResolver scriptBodyResolver) {
        this.scriptBodyResolver = scriptBodyResolver;
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull BindingTrace delegationTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.storageManager = lockBasedLazyResolveStorageManager;
        this.exceptionTracker = globalContext.getExceptionTracker();
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
        this.module = rootDescriptor;
        this.packages = this.storageManager.createMemoizedFunctionWithNullableValues(new MemoizedFunctionToNullable<FqName, LazyPackageDescriptor>(){

            @Override
            @Nullable
            public LazyPackageDescriptor invoke(FqName fqName2) {
                return ResolveSession.this.createPackage(fqName2);
            }
        });
        this.declarationProviderFactory = declarationProviderFactory;
        this.packageFragmentProvider = new PackageFragmentProvider(){

            @Override
            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getPackageFragments"));
                }
                List<PackageFragmentDescriptor> list = ContainerUtil.createMaybeSingletonList(ResolveSession.this.getPackageFragment(fqName2));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getPackageFragments"));
                }
                return list;
            }

            @Override
            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getSubPackagesOf"));
                }
                if (nameFilter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getSubPackagesOf"));
                }
                LazyPackageDescriptor packageDescriptor = ResolveSession.this.getPackageFragment(fqName2);
                if (packageDescriptor == null) {
                    List<FqName> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getSubPackagesOf"));
                    }
                    return list;
                }
                Collection<FqName> collection = packageDescriptor.getDeclarationProvider().getAllDeclaredSubPackages();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$2", "getSubPackagesOf"));
                }
                return collection;
            }
        };
        this.scriptDescriptors = this.storageManager.createMemoizedFunction(new Function1<JetScript, LazyScriptDescriptor>(){

            @Override
            public LazyScriptDescriptor invoke(JetScript script) {
                return new LazyScriptDescriptor(ResolveSession.this, ResolveSession.this.scriptBodyResolver, script, ScriptHeaderResolver.getScriptPriority(script));
            }
        });
        this.annotations = this.storageManager.createMemoizedFunction(new Function1<JetFile, LazyAnnotations>(){

            @Override
            public LazyAnnotations invoke(JetFile file) {
                JetScope scope2 = ResolveSession.this.getScopeProvider().getFileScope(file);
                LazyAnnotationsContextImpl lazyAnnotationContext = new LazyAnnotationsContextImpl(ResolveSession.this.annotationResolve, ResolveSession.this.storageManager, ResolveSession.this.trace, scope2);
                return new LazyAnnotations(lazyAnnotationContext, file.getAnnotationEntries());
            }
        });
    }

    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        PackageFragmentProvider packageFragmentProvider = this.packageFragmentProvider;
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getPackageFragmentProvider"));
        }
        return packageFragmentProvider;
    }

    @Override
    @Nullable
    public LazyPackageDescriptor getPackageFragment(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getPackageFragment"));
        }
        return (LazyPackageDescriptor)this.packages.invoke(fqName2);
    }

    @Nullable
    private LazyPackageDescriptor createPackage(FqName fqName2) {
        if (!fqName2.isRoot() && this.getPackageFragment(fqName2.parent()) == null) {
            return null;
        }
        PackageMemberDeclarationProvider provider = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2);
        if (provider == null) {
            return null;
        }
        return new LazyPackageDescriptor(this.module, fqName2, this, provider);
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getModuleDescriptor"));
        }
        return moduleDescriptor;
    }

    @NotNull
    public LazyResolveStorageManager getStorageManager() {
        LazyResolveStorageManager lazyResolveStorageManager = this.storageManager;
        if (lazyResolveStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getStorageManager"));
        }
        return lazyResolveStorageManager;
    }

    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.exceptionTracker;
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @Override
    @NotNull
    @ReadOnly
    public Collection<ClassDescriptor> getTopLevelClassDescriptors(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTopLevelClassDescriptors"));
        }
        if (fqName2.isRoot()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTopLevelClassDescriptors"));
            }
            return list;
        }
        PackageMemberDeclarationProvider provider = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2.parent());
        if (provider == null) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTopLevelClassDescriptors"));
            }
            return list;
        }
        List<ClassDescriptor> list = ContainerUtil.mapNotNull(provider.getClassOrObjectDeclarations(fqName2.shortName()), new Function<JetClassLikeInfo, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(JetClassLikeInfo classLikeInfo) {
                if (classLikeInfo instanceof JetScriptInfo) {
                    return ResolveSession.this.getClassDescriptorForScript(((JetScriptInfo)classLikeInfo).getScript());
                }
                JetClassOrObject classOrObject = classLikeInfo.getCorrespondingClassOrObject();
                if (classOrObject == null) {
                    return null;
                }
                return ResolveSession.this.getClassDescriptor(classOrObject);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTopLevelClassDescriptors"));
        }
        return list;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject) {
        JetObjectDeclaration objectDeclaration;
        JetClassObject classObjectElement;
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        if (classOrObject instanceof JetObjectDeclaration && (classObjectElement = (objectDeclaration = (JetObjectDeclaration)classOrObject).getClassObjectElement()) != null) {
            LazyClassDescriptor lazyClassDescriptor = this.getClassObjectDescriptor(classObjectElement);
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
            }
            return lazyClassDescriptor;
        }
        JetScope resolutionScope = this.getScopeProvider().getResolutionScopeForDeclaration(classOrObject);
        Name name = classOrObject.getNameAsSafeName();
        ClassifierDescriptor scopeDescriptor = resolutionScope.getClassifier(name);
        DeclarationDescriptor descriptor = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Could not find a classifier for %s.\nFound descriptor: %s (%s).\n", JetPsiUtil.getElementTextWithContext(classOrObject), scopeDescriptor != null ? DescriptorRenderer.DEBUG_TEXT.render(scopeDescriptor) : "null", scopeDescriptor != null ? scopeDescriptor.getContainingDeclaration().getClass() : null));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getClassDescriptorForScript(@NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptorForScript"));
        }
        JetScope resolutionScope = this.getScopeProvider().getResolutionScopeForDeclaration(script);
        FqName fqName2 = ScriptNameUtil.classNameForScript(script);
        ClassifierDescriptor classifier2 = resolutionScope.getClassifier(fqName2.shortName());
        assert (classifier2 != null) : "No descriptor for " + fqName2 + " in file " + script.getContainingFile();
        ClassDescriptor classDescriptor = (ClassDescriptor)classifier2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptorForScript"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public ScriptDescriptor getScriptDescriptor(@NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getScriptDescriptor"));
        }
        ScriptDescriptor scriptDescriptor = (ScriptDescriptor)this.scriptDescriptors.invoke(script);
        if (scriptDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getScriptDescriptor"));
        }
        return scriptDescriptor;
    }

    @NotNull
    LazyClassDescriptor getClassObjectDescriptor(@NotNull JetClassObject classObject) {
        LazyClassDescriptor parentClassDescriptor;
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassObjectDescriptor"));
        }
        JetClass aClass = JetStubbedPsiUtil.getContainingDeclaration(classObject, JetClass.class);
        if (aClass != null) {
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(aClass);
        } else {
            JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetObjectDeclaration.class);
            assert (objectDeclaration != null) : String.format("Class object %s can be in class or object in file %s", classObject, classObject.getContainingFile().getText());
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(objectDeclaration);
        }
        parentClassDescriptor.getClassObjectDescriptor();
        parentClassDescriptor.getDescriptorsForExtraClassObjects();
        DeclarationDescriptor classObjectDescriptor2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObject.getObjectDeclaration());
        assert (classObjectDescriptor2 != null) : "No descriptor found for " + JetPsiUtil.getElementTextWithContext(classObject);
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)classObjectDescriptor2;
        if (lazyClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassObjectDescriptor"));
        }
        return lazyClassDescriptor;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        DeclarationProviderFactory declarationProviderFactory = this.declarationProviderFactory;
        if (declarationProviderFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getDeclarationProviderFactory"));
        }
        return declarationProviderFactory;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        DeclarationDescriptor result2 = declaration.accept(new JetVisitor<DeclarationDescriptor, Void>(){

            @Override
            public DeclarationDescriptor visitClass(@NotNull JetClass klass, Void data2) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitClass"));
                }
                return ResolveSession.this.getClassDescriptor(klass);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitObjectDeclaration"));
                }
                PsiElement parent = declaration.getParent();
                if (parent instanceof JetClassObject) {
                    JetClassObject jetClassObject = (JetClassObject)parent;
                    return ResolveSession.this.resolveToDescriptor(jetClassObject);
                }
                return ResolveSession.this.getClassDescriptor(declaration);
            }

            @Override
            public DeclarationDescriptor visitClassObject(@NotNull JetClassObject classObject, Void data2) {
                if (classObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitClassObject"));
                }
                return ResolveSession.this.getClassObjectDescriptor(classObject);
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull JetTypeParameter parameter, Void data2) {
                List<TypeParameterDescriptor> typeParameters;
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitTypeParameter"));
                }
                JetTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, JetTypeParameterListOwner.class);
                DeclarationDescriptor ownerDescriptor = ResolveSession.this.resolveToDescriptor(ownerElement);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = parameter.getNameAsSafeName();
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull JetNamedFunction function, Void data2) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitNamedFunction"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getScopeProvider().getResolutionScopeForDeclaration(function);
                scopeForDeclaration.getFunctions(function.getNameAsSafeName());
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull JetParameter parameter, Void data2) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitParameter"));
                }
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof JetClass) {
                    JetClass jetClass = (JetClass)grandFather;
                    ClassDescriptor classDescriptor = ResolveSession.this.getClassDescriptor(jetClass);
                    if (parameter.hasValOrVarNode()) {
                        classDescriptor.getDefaultType().getMemberScope().getProperties(parameter.getNameAsSafeName());
                        return ResolveSession.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor2 != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor2.getValueParameters();
                    return ResolveSession.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof JetNamedFunction) {
                    FunctionDescriptor function = (FunctionDescriptor)this.visitNamedFunction((JetNamedFunction)grandFather, data2);
                    function.getValueParameters();
                    return ResolveSession.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull JetProperty property2, Void data2) {
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitProperty"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getScopeProvider().getResolutionScopeForDeclaration(property2);
                scopeForDeclaration.getProperties(property2.getNameAsSafeName());
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            }

            @Override
            public DeclarationDescriptor visitJetElement(@NotNull JetElement element, Void data2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$6", "visitJetElement"));
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + JetPsiUtil.getElementTextWithContext(element));
            }
        }, null);
        if (result2 == null) {
            throw new IllegalStateException("No descriptor resolved for " + declaration + ":\n" + JetPsiUtil.getElementTextWithContext(declaration));
        }
        DeclarationDescriptor declarationDescriptor = result2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    public Annotations getFileAnnotations(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getFileAnnotations"));
        }
        Annotations annotations2 = (Annotations)this.annotations.invoke(file);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getFileAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    private List<LazyPackageDescriptor> getAllPackages() {
        LazyPackageDescriptor rootPackage = this.getPackageFragment(FqName.ROOT);
        assert (rootPackage != null) : "Root package must be initialized";
        List<LazyPackageDescriptor> list = this.collectAllPackages(Lists.<LazyPackageDescriptor>newArrayList(), rootPackage);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getAllPackages"));
        }
        return list;
    }

    @NotNull
    private List<LazyPackageDescriptor> collectAllPackages(@NotNull List<LazyPackageDescriptor> result2, @NotNull LazyPackageDescriptor current) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        result2.add(current);
        for (FqName subPackage : this.packageFragmentProvider.getSubPackagesOf(current.getFqName(), JetScope.ALL_NAME_FILTER)) {
            LazyPackageDescriptor fragment = this.getPackageFragment(subPackage);
            assert (fragment != null) : "Couldn't find fragment for " + subPackage;
            this.collectAllPackages(result2, fragment);
        }
        List<LazyPackageDescriptor> list = result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        return list;
    }

    @Override
    public void forceResolveAll() {
        for (LazyPackageDescriptor lazyPackage : this.getAllPackages()) {
            ForceResolveUtil.forceResolveAllContents(lazyPackage);
        }
    }

    @Override
    @NotNull
    public ScopeProvider getScopeProvider() {
        ScopeProvider scopeProvider = this.scopeProvider;
        if (scopeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getScopeProvider"));
        }
        return scopeProvider;
    }

    @NotNull
    public JetImportsFactory getJetImportsFactory() {
        JetImportsFactory jetImportsFactory = this.jetImportFactory;
        if (jetImportsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getJetImportsFactory"));
        }
        return jetImportsFactory;
    }

    @NotNull
    public AnnotationResolver getAnnotationResolver() {
        AnnotationResolver annotationResolver = this.annotationResolve;
        if (annotationResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getAnnotationResolver"));
        }
        return annotationResolver;
    }

    @NotNull
    public DescriptorResolver getDescriptorResolver() {
        DescriptorResolver descriptorResolver = this.descriptorResolver;
        if (descriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getDescriptorResolver"));
        }
        return descriptorResolver;
    }

    @NotNull
    public TypeResolver getTypeResolver() {
        TypeResolver typeResolver = this.typeResolver;
        if (typeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTypeResolver"));
        }
        return typeResolver;
    }

    @NotNull
    public QualifiedExpressionResolver getQualifiedExpressionResolver() {
        QualifiedExpressionResolver qualifiedExpressionResolver = this.qualifiedExpressionResolver;
        if (qualifiedExpressionResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getQualifiedExpressionResolver"));
        }
        return qualifiedExpressionResolver;
    }
}

