/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorLoader;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.org.objectweb.asm.Type;

public class PackagePartClassUtils {
    public static int getPathHashCode(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPathHashCode"));
        }
        return FileUtil.toSystemDependentName(file.getPath()).hashCode();
    }

    @NotNull
    private static String replaceSpecialSymbols(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "replaceSpecialSymbols"));
        }
        String string = str.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "replaceSpecialSymbols"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull FqName facadeFqName, @NotNull VirtualFile file) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        String fileName = FileUtil.getNameWithoutExtension(PathUtil.getFileName(file.getName()));
        String srcName = String.format("%s$%s$%08x", facadeFqName.shortName().asString(), PackagePartClassUtils.replaceSpecialSymbols(fileName), PackagePartClassUtils.getPathHashCode(file));
        FqName fqName2 = facadeFqName.parent().child(Name.identifier(srcName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static Type getPackagePartType(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartType"));
        }
        Type type2 = Type.getObjectType(PackagePartClassUtils.getPackagePartInternalName(file));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartType"));
        }
        return type2;
    }

    @NotNull
    public static String getPackagePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartInternalName"));
        }
        FqName fqName2 = PackagePartClassUtils.getPackagePartFqName(file);
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartInternalName"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        FqName fqName2 = PackagePartClassUtils.getPackagePartFqName(PackageClassUtils.getPackageClassFqName(file.getPackageFqName()), file.getVirtualFile());
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull DeserializedCallableMemberDescriptor callable2) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        FqName packageFqName = ((PackageFragmentDescriptor)callable2.getContainingDeclaration()).getFqName();
        FqName fqName2 = packageFqName.child(BaseDescriptorLoader.getPackagePartClassName(callable2));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static List<JetFile> getPackageFilesWithCallables(@NotNull Collection<JetFile> packageFiles) {
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackageFilesWithCallables"));
        }
        List<JetFile> list = ContainerUtil.filter(packageFiles, new Condition<JetFile>(){

            @Override
            public boolean value(JetFile packageFile) {
                for (JetDeclaration declaration : packageFile.getDeclarations()) {
                    if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
                    return true;
                }
                return false;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/PackagePartClassUtils", "getPackageFilesWithCallables"));
        }
        return list;
    }
}

