/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;

public class DeserializedResolverUtils {
    private DeserializedResolverUtils() {
    }

    @NotNull
    public static FqName kotlinFqNameToJavaFqName(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        List<Name> segments = kotlinFqName.pathSegments();
        ArrayList<String> correctedSegments = new ArrayList<String>(segments.size());
        for (Name segment : segments) {
            correctedSegments.add(SpecialNames.isClassObjectName(segment) ? "object" : segment.getIdentifier());
        }
        FqName fqName2 = FqName.fromSegments(correctedSegments);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static ClassId kotlinClassIdToJavaClassId(@NotNull ClassId kotlinClassId) {
        if (kotlinClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClassId", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinClassIdToJavaClassId"));
        }
        ClassId classId = new ClassId(kotlinClassId.getPackageFqName(), DeserializedResolverUtils.kotlinFqNameToJavaFqName(kotlinClassId.getRelativeClassName()).toUnsafe());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinClassIdToJavaClassId"));
        }
        return classId;
    }

    @NotNull
    public static FqNameUnsafe javaFqNameToKotlinFqName(@NotNull FqName javaFqName) {
        if (javaFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFqName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
        }
        if (javaFqName.isRoot()) {
            FqNameUnsafe fqNameUnsafe = javaFqName.toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        List<Name> segments = javaFqName.pathSegments();
        ArrayList<Name> correctedSegments = new ArrayList<Name>(segments.size());
        correctedSegments.add(segments.get(0));
        for (int i = 1; i < segments.size(); ++i) {
            Name segment = segments.get(i);
            boolean isClassObjectName = segment.asString().equals("object");
            Name correctedSegment = isClassObjectName ? SpecialNames.getClassObjectName(segments.get(i - 1)) : segment;
            correctedSegments.add(correctedSegment);
        }
        FqNameUnsafe fqNameUnsafe = FqNameUnsafe.fromSegments(correctedSegments);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static ClassId javaClassIdToKotlinClassId(@NotNull ClassId javaClassId) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaClassIdToKotlinClassId"));
        }
        ClassId classId = new ClassId(javaClassId.getPackageFqName(), DeserializedResolverUtils.javaFqNameToKotlinFqName(javaClassId.getRelativeClassName().toSafe()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaClassIdToKotlinClassId"));
        }
        return classId;
    }

    @NotNull
    public static ClassId getClassId(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "getClassId"));
        }
        DeclarationDescriptor owner = descriptor.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            ClassId classId = new ClassId(((PackageFragmentDescriptor)owner).getFqName(), descriptor.getName());
            if (classId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "getClassId"));
            }
            return classId;
        }
        ClassId classId = DeserializedResolverUtils.getClassId((ClassDescriptor)owner).createNestedClassId(descriptor.getName());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "getClassId"));
        }
        return classId;
    }
}

