/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationComponents;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializationComponentsForJava;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context2.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.CLASS);
        if (data2 != null) {
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), JavaProtoBufUtil.readClassDataFrom(data2));
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.PACKAGE_FACADE);
        if (data2 != null) {
            PackageData packageData = JavaProtoBufUtil.readPackageDataFrom(data2);
            return new DeserializedPackageMemberScope(descriptor, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull KotlinClassHeader.Kind expectedKind) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKind", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass, header.getVersion());
        } else if (header.getKind() == expectedKind) {
            return header.getAnnotationData();
        }
        return null;
    }
}

