/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializationPackage;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotatedCallableKind;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationLoader;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ConstantsPackage;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorLoadersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class AnnotationDescriptorLoader
extends BaseDescriptorLoader
implements AnnotationLoader {
    private final ModuleDescriptor module;

    public AnnotationDescriptorLoader(@NotNull ModuleDescriptor module, @NotNull DescriptorLoadersStorage storage2, @NotNull KotlinClassFinder kotlinClassFinder, @NotNull ErrorReporter errorReporter) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "<init>"));
        }
        if (kotlinClassFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClassFinder", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "<init>"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "<init>"));
        }
        super(kotlinClassFinder, errorReporter, storage2);
        this.module = module;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadClassAnnotations"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadClassAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadClassAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findKotlinClassByDescriptor(descriptor);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading class annotations is not found: " + descriptor, null);
            List<AnnotationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadClassAnnotations"));
            }
            return list;
        }
        final ArrayList<AnnotationDescriptor> result2 = new ArrayList<AnnotationDescriptor>(1);
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId) {
                if (classId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$1", "visitAnnotation"));
                }
                return AnnotationDescriptorLoader.resolveAnnotation(classId, result2, AnnotationDescriptorLoader.this.module);
            }

            @Override
            public void visitEnd() {
            }
        });
        ArrayList<AnnotationDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadClassAnnotations"));
        }
        return arrayList;
    }

    @Nullable
    public static KotlinJvmBinaryClass.AnnotationArgumentVisitor resolveAnnotation(@NotNull ClassId classId, final @NotNull List<AnnotationDescriptor> result2, final @NotNull ModuleDescriptor moduleDescriptor) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveAnnotation"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveAnnotation"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveAnnotation"));
        }
        if (JvmAnnotationNames.isSpecialAnnotation(classId, true)) {
            return null;
        }
        final ClassDescriptor annotationClass = AnnotationDescriptorLoader.resolveClass(classId, moduleDescriptor);
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){
            private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> arguments = new HashMap();

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                if (name != null) {
                    this.setArgumentValueByName(name, this.createConstant(name, value));
                }
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "visitEnum"));
                }
                if (enumClassId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "visitEnum"));
                }
                this.setArgumentValueByName(name, this.enumEntryValue(enumClassId, enumEntryName));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(final @NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "visitArray"));
                }
                return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(){
                    private final ArrayList<CompileTimeConstant<?>> elements = new ArrayList();

                    @Override
                    public void visit(@Nullable Object value) {
                        this.elements.add(this.createConstant(name, value));
                    }

                    @Override
                    public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        if (enumClassId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2$1", "visitEnum"));
                        }
                        if (enumEntryName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2$1", "visitEnum"));
                        }
                        this.elements.add(this.enumEntryValue(enumClassId, enumEntryName));
                    }

                    @Override
                    public void visitEnd() {
                        ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(name, annotationClass);
                        if (parameter != null) {
                            this.elements.trimToSize();
                            arguments.put(parameter, new ArrayValue(this.elements, parameter.getType(), true, false));
                        }
                    }
                };
            }

            @NotNull
            private CompileTimeConstant<?> enumEntryValue(@NotNull ClassId enumClassId, @NotNull Name name) {
                ClassifierDescriptor classifier2;
                if (enumClassId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "enumEntryValue"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "enumEntryValue"));
                }
                ClassDescriptor enumClass = AnnotationDescriptorLoader.resolveClass(enumClassId, moduleDescriptor);
                if (enumClass.getKind() == ClassKind.ENUM_CLASS && (classifier2 = enumClass.getUnsubstitutedInnerClassesScope().getClassifier(name)) instanceof ClassDescriptor) {
                    EnumValue enumValue = new EnumValue((ClassDescriptor)classifier2, false);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "enumEntryValue"));
                    }
                    return enumValue;
                }
                ErrorValue errorValue = ErrorValue.create("Unresolved enum entry: " + enumClassId + "." + name);
                if (errorValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "enumEntryValue"));
                }
                return errorValue;
            }

            @Override
            public void visitEnd() {
                result2.add(new AnnotationDescriptorImpl(annotationClass.getDefaultType(), this.arguments));
            }

            @NotNull
            private CompileTimeConstant<?> createConstant(@Nullable Name name, @Nullable Object value) {
                ErrorValue argument = ConstantsPackage.createCompileTimeConstant(value, true, false, false, null);
                ErrorValue errorValue = argument != null ? argument : ErrorValue.create("Unsupported annotation argument: " + name);
                if (errorValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "createConstant"));
                }
                return errorValue;
            }

            private void setArgumentValueByName(@NotNull Name name, @NotNull CompileTimeConstant<?> argumentValue) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "setArgumentValueByName"));
                }
                if (argumentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentValue", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader$2", "setArgumentValueByName"));
                }
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(name, annotationClass);
                if (parameter != null) {
                    this.arguments.put(parameter, argumentValue);
                }
            }
        };
    }

    @NotNull
    private static ClassDescriptor resolveClass(@NotNull ClassId javaClassId, @NotNull ModuleDescriptor moduleDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveClass"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveClass"));
        }
        ClassId classId = DeserializedResolverUtils.javaClassIdToKotlinClassId(javaClassId);
        ClassDescriptor classDescriptor = SerializationPackage.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        ClassDescriptor classDescriptor2 = classDescriptor != null ? classDescriptor : ErrorUtils.createErrorClass(classId.asSingleFqName().asString());
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "resolveClass"));
        }
        return classDescriptor2;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
        }
        DescriptorLoadersStorage.MemberSignature signature = AnnotationDescriptorLoader.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            List<AnnotationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
            }
            return list;
        }
        List<AnnotationDescriptor> list = this.findClassAndLoadMemberAnnotations(container, proto, nameResolver, kind, signature);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadCallableAnnotations"));
        }
        return list;
    }

    @NotNull
    private List<AnnotationDescriptor> findClassAndLoadMemberAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind, @NotNull DescriptorLoadersStorage.MemberSignature signature) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading member annotations is not found: " + container, null);
            List<AnnotationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
            }
            return list;
        }
        List<AnnotationDescriptor> descriptors = this.storage.getStorageForClass(kotlinClass).getMemberAnnotations().get(signature);
        List<Object> list = descriptors == null ? Collections.emptyList() : descriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "findClassAndLoadMemberAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable callable2, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter proto) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        DescriptorLoadersStorage.MemberSignature methodSignature = AnnotationDescriptorLoader.getCallableSignature(callable2, nameResolver, kind);
        if (methodSignature != null && proto.hasExtension(JavaProtoBuf.index)) {
            DescriptorLoadersStorage.MemberSignature paramSignature = DescriptorLoadersStorage.MemberSignature.fromMethodSignatureAndParameterIndex(methodSignature, proto.getExtension(JavaProtoBuf.index));
            List<AnnotationDescriptor> list = this.findClassAndLoadMemberAnnotations(container, callable2, nameResolver, kind, paramSignature);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
            }
            return list;
        }
        List<AnnotationDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorLoader", "loadValueParameterAnnotations"));
        }
        return list;
    }
}

