/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.jvmSignature;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmMethodSignature {
    private final Method asmMethod;
    private final String genericsSignature;
    private final List<JvmMethodParameterSignature> valueParameters;

    public JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @NotNull List<JvmMethodParameterSignature> valueParameters) {
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "<init>"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "<init>"));
        }
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.valueParameters = valueParameters;
    }

    @NotNull
    public Method getAsmMethod() {
        Method method = this.asmMethod;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "getAsmMethod"));
        }
        return method;
    }

    @Nullable
    public String getGenericsSignature() {
        return this.genericsSignature;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getValueParameters() {
        List<JvmMethodParameterSignature> list = this.valueParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "getValueParameters"));
        }
        return list;
    }

    @NotNull
    public Type getReturnType() {
        Type type2 = this.asmMethod.getReturnType();
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "getReturnType"));
        }
        return type2;
    }

    @NotNull
    public JvmMethodSignature replaceName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "replaceName"));
        }
        JvmMethodSignature jvmMethodSignature = newName.equals(this.asmMethod.getName()) ? this : new JvmMethodSignature(new Method(newName, this.asmMethod.getDescriptor()), this.genericsSignature, this.valueParameters);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/jvmSignature/JvmMethodSignature", "replaceName"));
        }
        return jvmMethodSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmMethodSignature)) {
            return false;
        }
        JvmMethodSignature that = (JvmMethodSignature)o;
        return this.asmMethod.equals(that.asmMethod) && (this.genericsSignature == null ? that.genericsSignature == null : this.genericsSignature.equals(that.genericsSignature)) && ((Object)this.valueParameters).equals(that.valueParameters);
    }

    public int hashCode() {
        int result2 = this.asmMethod.hashCode();
        result2 = 31 * result2 + (this.genericsSignature != null ? this.genericsSignature.hashCode() : 0);
        result2 = 31 * result2 + ((Object)this.valueParameters).hashCode();
        return result2;
    }

    public String toString() {
        return this.asmMethod.toString();
    }
}

