/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.descriptor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaCallableMemberDescriptor;

public class JavaConstructorDescriptor
extends ConstructorDescriptorImpl
implements JavaCallableMemberDescriptor {
    private Boolean hasStableParameterNames;
    private Boolean hasSynthesizedParameterNames;

    protected JavaConstructorDescriptor(@NotNull ClassDescriptor containingDeclaration, @Nullable JavaConstructorDescriptor original, @NotNull Annotations annotations2, boolean isPrimary, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "<init>"));
        }
        super(containingDeclaration, original, annotations2, isPrimary, kind, source);
        this.hasStableParameterNames = null;
        this.hasSynthesizedParameterNames = null;
    }

    @NotNull
    public static JavaConstructorDescriptor createJavaConstructor(@NotNull ClassDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean isPrimary, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createJavaConstructor"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createJavaConstructor"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createJavaConstructor"));
        }
        JavaConstructorDescriptor javaConstructorDescriptor = new JavaConstructorDescriptor(containingDeclaration, null, annotations2, isPrimary, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (javaConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createJavaConstructor"));
        }
        return javaConstructorDescriptor;
    }

    @Override
    public boolean hasStableParameterNames() {
        assert (this.hasStableParameterNames != null) : "hasStableParameterNames was not set: " + this;
        return this.hasStableParameterNames;
    }

    public void setHasStableParameterNames(boolean hasStableParameterNames) {
        this.hasStableParameterNames = hasStableParameterNames;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        assert (this.hasSynthesizedParameterNames != null) : "hasSynthesizedParameterNames was not set: " + this;
        return this.hasSynthesizedParameterNames;
    }

    public void setHasSynthesizedParameterNames(boolean hasSynthesizedParameterNames) {
        this.hasSynthesizedParameterNames = hasSynthesizedParameterNames;
    }

    @Override
    @NotNull
    protected JavaConstructorDescriptor createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (kind != CallableMemberDescriptor.Kind.DECLARATION && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            throw new IllegalStateException("Attempt at creating a constructor that is not a declaration: \ncopy from: " + this + "\n" + "newOwner: " + newOwner + "\n" + "kind: " + (Object)((Object)kind));
        }
        JavaConstructorDescriptor result2 = new JavaConstructorDescriptor((ClassDescriptor)newOwner, this, Annotations.EMPTY, this.isPrimary, kind, SourceElement.NO_SOURCE);
        result2.setHasStableParameterNames(this.hasStableParameterNames());
        result2.setHasSynthesizedParameterNames(this.hasSynthesizedParameterNames());
        JavaConstructorDescriptor javaConstructorDescriptor = result2;
        if (javaConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaConstructorDescriptor", "createSubstitutedCopy"));
        }
        return javaConstructorDescriptor;
    }
}

