/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class JavaResolverUtils {
    private JavaResolverUtils() {
    }

    public static boolean isCompiledKotlinClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "isCompiledKotlinClass"));
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        return javaClass.getOriginKind() == JavaClass.OriginKind.COMPILED && javaClass.findAnnotation(JvmAnnotationNames.KOTLIN_CLASS) != null;
    }

    public static boolean isCompiledKotlinPackageClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "isCompiledKotlinPackageClass"));
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        return javaClass.getOriginKind() == JavaClass.OriginKind.COMPILED && javaClass.findAnnotation(JvmAnnotationNames.KOTLIN_PACKAGE) != null;
    }

    public static boolean isCompiledKotlinClassOrPackageClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "isCompiledKotlinClassOrPackageClass"));
        }
        return JavaResolverUtils.isCompiledKotlinClass(psiClass) || JavaResolverUtils.isCompiledKotlinPackageClass(psiClass);
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "erasure"));
        }
        return JavaResolverUtils.erasure(type2, JavaTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type2, @NotNull JavaTypeSubstitutor substitutor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "erasure"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "erasure"));
        }
        if (type2 instanceof JavaClassifierType) {
            JavaClassifier classifier2 = ((JavaClassifierType)type2).getClassifier();
            if (classifier2 instanceof JavaClass) {
                return ((JavaClass)classifier2).getDefaultType();
            }
            if (classifier2 instanceof JavaTypeParameter) {
                JavaTypeParameter typeParameter = (JavaTypeParameter)classifier2;
                return JavaResolverUtils.typeParameterErasure(typeParameter, new HashSet<JavaTypeParameter>(), substitutor);
            }
            return null;
        }
        if (type2 instanceof JavaPrimitiveType) {
            return type2;
        }
        if (type2 instanceof JavaArrayType) {
            JavaType erasure = JavaResolverUtils.erasure(((JavaArrayType)type2).getComponentType(), substitutor);
            return erasure == null ? null : erasure.createArrayType();
        }
        if (type2 instanceof JavaWildcardType) {
            JavaWildcardType wildcardType = (JavaWildcardType)type2;
            JavaType bound = wildcardType.getBound();
            if (bound != null && wildcardType.isExtends()) {
                return JavaResolverUtils.erasure(bound, substitutor);
            }
            return wildcardType.getTypeProvider().createJavaLangObjectType();
        }
        throw new IllegalStateException("Unsupported type: " + type2);
    }

    @Nullable
    private static JavaType typeParameterErasure(@NotNull JavaTypeParameter typeParameter, @NotNull HashSet<JavaTypeParameter> visited, @NotNull JavaTypeSubstitutor substitutor) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "typeParameterErasure"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "typeParameterErasure"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "typeParameterErasure"));
        }
        Collection<JavaClassifierType> upperBounds = typeParameter.getUpperBounds();
        if (!upperBounds.isEmpty()) {
            JavaClassifier classifier2 = upperBounds.iterator().next().getClassifier();
            if (classifier2 instanceof JavaTypeParameter && !visited.contains(classifier2)) {
                JavaTypeParameter typeParameterBound = (JavaTypeParameter)classifier2;
                visited.add(typeParameterBound);
                JavaType substitutedType = substitutor.substitute(typeParameterBound);
                if (substitutedType != null) {
                    return JavaResolverUtils.erasure(substitutedType);
                }
                return JavaResolverUtils.typeParameterErasure(typeParameterBound, visited, substitutor);
            }
            if (classifier2 instanceof JavaClass) {
                return ((JavaClass)classifier2).getDefaultType();
            }
        }
        return typeParameter.getTypeProvider().createJavaLangObjectType();
    }

    @NotNull
    public static Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> recreateTypeParametersAndReturnMapping(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> result2 = new LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>();
        for (TypeParameterDescriptor typeParameter : originalParameters) {
            result2.put(typeParameter, TypeParameterDescriptorImpl.createForFurtherModification(newOwner == null ? typeParameter.getContainingDeclaration() : newOwner, typeParameter.getAnnotations(), typeParameter.isReified(), typeParameter.getVariance(), typeParameter.getName(), typeParameter.getIndex(), SourceElement.NO_SOURCE));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static TypeSubstitutor createSubstitutorForTypeParameters(@NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters) {
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "createSubstitutorForTypeParameters"));
        }
        HashMap<TypeConstructor, TypeProjection> typeSubstitutionContext = new HashMap<TypeConstructor, TypeProjection>();
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameter : originalToAltTypeParameters.entrySet()) {
            typeSubstitutionContext.put(originalToAltTypeParameter.getKey().getTypeConstructor(), new TypeProjectionImpl(originalToAltTypeParameter.getValue().getDefaultType()));
        }
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(typeSubstitutionContext);
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaResolverUtils", "createSubstitutorForTypeParameters"));
        }
        return typeSubstitutor;
    }
}

