/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class ResolutionCandidate<D extends CallableDescriptor> {
    private final Call call;
    private final D candidateDescriptor;
    private ReceiverValue dispatchReceiver;
    private ReceiverValue extensionReceiver;
    private ExplicitReceiverKind explicitReceiverKind;

    private ResolutionCandidate(@NotNull Call call, @NotNull D descriptor, @NotNull ReceiverValue dispatchReceiver, @NotNull ReceiverValue extensionReceiver2, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (extensionReceiver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        this.call = call;
        this.candidateDescriptor = descriptor;
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver2;
        this.explicitReceiverKind = explicitReceiverKind;
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor, @NotNull ReceiverValue dispatchReceiver, @NotNull ReceiverValue receiverArgument, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor, dispatchReceiver, receiverArgument, explicitReceiverKind);
    }

    public void setDispatchReceiver(@NotNull ReceiverValue dispatchReceiver) {
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setDispatchReceiver"));
        }
        this.dispatchReceiver = dispatchReceiver;
    }

    public void setExtensionReceiver(@NotNull ReceiverValue extensionReceiver2) {
        if (extensionReceiver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setExtensionReceiver"));
        }
        this.extensionReceiver = extensionReceiver2;
    }

    public void setExplicitReceiverKind(@NotNull ExplicitReceiverKind explicitReceiverKind) {
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setExplicitReceiverKind"));
        }
        this.explicitReceiverKind = explicitReceiverKind;
    }

    @NotNull
    public Call getCall() {
        Call call = this.call;
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getCall"));
        }
        return call;
    }

    @NotNull
    public D getDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getDescriptor"));
        }
        return d;
    }

    @NotNull
    public ReceiverValue getDispatchReceiver() {
        ReceiverValue receiverValue = this.dispatchReceiver;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getDispatchReceiver"));
        }
        return receiverValue;
    }

    @NotNull
    public ReceiverValue getExtensionReceiver() {
        ReceiverValue receiverValue = this.extensionReceiver;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getExtensionReceiver"));
        }
        return receiverValue;
    }

    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @NotNull
    public static <D extends CallableDescriptor> List<ResolutionCandidate<D>> convertCollection(@NotNull Call call, @NotNull Collection<? extends D> descriptors) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        ArrayList<ResolutionCandidate<D>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            result2.add(ResolutionCandidate.create(call, descriptor));
        }
        ArrayList<ResolutionCandidate<D>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        return arrayList;
    }

    public String toString() {
        return this.candidateDescriptor.toString();
    }
}

