/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.smartcasts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.Nullability;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

class DelegatingDataFlowInfo
implements DataFlowInfo {
    private static final ImmutableMap<DataFlowValue, Nullability> EMPTY_NULLABILITY_INFO = ImmutableMap.of();
    private static final SetMultimap<DataFlowValue, JetType> EMPTY_TYPE_INFO = DelegatingDataFlowInfo.newTypeInfo();
    @Nullable
    private final DataFlowInfo parent;
    @NotNull
    private final ImmutableMap<DataFlowValue, Nullability> nullabilityInfo;
    @NotNull
    private final SetMultimap<DataFlowValue, JetType> typeInfo;

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, JetType> typeInfo) {
        if (nullabilityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullabilityInfo", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        this.parent = parent;
        this.nullabilityInfo = nullabilityInfo;
        this.typeInfo = typeInfo;
    }

    @Override
    @NotNull
    public Map<DataFlowValue, Nullability> getCompleteNullabilityInfo() {
        HashMap<DataFlowValue, Nullability> result2 = Maps.newHashMap();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (Map.Entry entry : info.nullabilityInfo.entrySet()) {
                DataFlowValue key = (DataFlowValue)entry.getKey();
                Nullability value = (Nullability)((Object)entry.getValue());
                if (result2.containsKey(key)) continue;
                result2.put(key, value);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        HashMap<DataFlowValue, Nullability> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteNullabilityInfo"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public SetMultimap<DataFlowValue, JetType> getCompleteTypeInfo() {
        SetMultimap<DataFlowValue, JetType> result2 = DelegatingDataFlowInfo.newTypeInfo();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (DataFlowValue key : info.typeInfo.keySet()) {
                result2.putAll(key, info.typeInfo.get(key));
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        SetMultimap<DataFlowValue, JetType> setMultimap = result2;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteTypeInfo"));
        }
        return setMultimap;
    }

    @Override
    @NotNull
    public Nullability getNullability(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        if (!key.isStableIdentifier()) {
            Nullability nullability = key.getImmanentNullability();
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
            }
            return nullability;
        }
        Nullability nullability = this.nullabilityInfo.get(key);
        Nullability nullability2 = nullability != null ? nullability : (this.parent != null ? this.parent.getNullability(key) : key.getImmanentNullability());
        if (nullability2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        return nullability2;
    }

    private boolean putNullability(@NotNull Map<DataFlowValue, Nullability> map, @NotNull DataFlowValue value, @NotNull Nullability nullability) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (!value.isStableIdentifier()) {
            return false;
        }
        map.put(value, nullability);
        return nullability != this.getNullability(value);
    }

    @Override
    @NotNull
    public Set<JetType> getPossibleTypes(@NotNull DataFlowValue key) {
        Set<JetType> types;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        Set<JetType> theseTypes = this.typeInfo.get(key);
        Set<JetType> set = types = this.parent == null ? theseTypes : Sets.union(theseTypes, this.parent.getPossibleTypes(key));
        if (this.getNullability(key).canBeNull()) {
            Set<JetType> set2 = types;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
            }
            return set2;
        }
        HashSet<JetType> enrichedTypes = Sets.newHashSetWithExpectedSize(types.size() + 1);
        JetType originalType = key.getType();
        if (originalType.isNullable()) {
            enrichedTypes.add(TypeUtils.makeNotNullable(originalType));
        }
        for (JetType type2 : types) {
            enrichedTypes.add(TypeUtils.makeNotNullable(type2));
        }
        HashSet<JetType> hashSet = enrichedTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public DataFlowInfo equate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB));
        DelegatingDataFlowInfo delegatingDataFlowInfo = (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA))) ? new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO) : this;
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo disequate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB.invert()));
        DelegatingDataFlowInfo delegatingDataFlowInfo = (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA.invert()))) ? new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO) : this;
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo establishSubtyping(@NotNull DataFlowValue value, @NotNull JetType type2) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (((Object)value.getType()).equals(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        if (this.getPossibleTypes(value).contains(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        ImmutableMap<DataFlowValue, Nullability> newNullabilityInfo = type2.isNullable() ? EMPTY_NULLABILITY_INFO : ImmutableMap.of(value, Nullability.NOT_NULL);
        ImmutableSetMultimap<DataFlowValue, JetType> newTypeInfo = ImmutableSetMultimap.of(value, type2);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, newNullabilityInfo, newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo and(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        if (otherInfo == EMPTY) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = otherInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            Nullability flags = thisFlags.and(otherFlags);
            if (flags == thisFlags) continue;
            nullabilityMapBuilder.put(key, flags);
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        if (nullabilityMapBuilder.isEmpty() && DelegatingDataFlowInfo.containsAll(myTypeInfo, otherTypeInfo)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(nullabilityMapBuilder), otherTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        return delegatingDataFlowInfo;
    }

    private static boolean containsAll(SetMultimap<DataFlowValue, JetType> first, SetMultimap<DataFlowValue, JetType> second) {
        return first.entries().containsAll(second.entries());
    }

    @Override
    @NotNull
    public DataFlowInfo or(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        if (otherInfo == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            nullabilityMapBuilder.put(key, thisFlags.or(otherFlags));
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        for (DataFlowValue key : Sets.intersection(myTypeInfo.keySet(), otherTypeInfo.keySet())) {
            Set<JetType> thisTypes = myTypeInfo.get(key);
            Set<JetType> otherTypes = otherTypeInfo.get(key);
            newTypeInfo.putAll(key, Sets.intersection(thisTypes, otherTypes));
        }
        if (nullabilityMapBuilder.isEmpty() && newTypeInfo.isEmpty()) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(null, ImmutableMap.copyOf(nullabilityMapBuilder), newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        return delegatingDataFlowInfo;
    }

    @NotNull
    static SetMultimap<DataFlowValue, JetType> newTypeInfo() {
        LinkedHashMultimap<DataFlowValue, JetType> linkedHashMultimap = LinkedHashMultimap.create();
        if (linkedHashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/smartcasts/DelegatingDataFlowInfo", "newTypeInfo"));
        }
        return linkedHashMultimap;
    }

    public String toString() {
        if (this.typeInfo.isEmpty() && this.nullabilityInfo.isEmpty()) {
            return "EMPTY";
        }
        return "Non-trivial DataFlowInfo";
    }
}

