/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;

public class ConstraintPosition {
    public static final ConstraintPosition RECEIVER_POSITION = new ConstraintPosition("RECEIVER_POSITION", true);
    public static final ConstraintPosition EXPECTED_TYPE_POSITION = new ConstraintPosition("EXPECTED_TYPE_POSITION", true);
    public static final ConstraintPosition FROM_COMPLETER = new ConstraintPosition("FROM_COMPLETER", true);
    public static final ConstraintPosition SPECIAL = new ConstraintPosition("SPECIAL", true);
    private static final Map<Integer, ConstraintPosition> valueParameterPositions = new HashMap<Integer, ConstraintPosition>();
    private static final Map<Integer, ConstraintPosition> typeBoundPositions = new HashMap<Integer, ConstraintPosition>();
    private final String debugName;
    private final boolean isStrong;

    public static ConstraintPosition getValueParameterPosition(int index2) {
        ConstraintPosition position = valueParameterPositions.get(index2);
        if (position == null) {
            position = new ConstraintPosition("VALUE_PARAMETER_POSITION(" + index2 + ")", true);
            valueParameterPositions.put(index2, position);
        }
        return position;
    }

    public static ConstraintPosition getTypeBoundPosition(int index2) {
        ConstraintPosition position = typeBoundPositions.get(index2);
        if (position == null) {
            position = new ConstraintPosition("TYPE_BOUND_POSITION(" + index2 + ")", false);
            typeBoundPositions.put(index2, position);
        }
        return position;
    }

    public static ConstraintPosition getCompoundConstraintPosition(ConstraintPosition ... positions) {
        return new CompoundConstraintPosition(Arrays.asList(positions));
    }

    private ConstraintPosition(String name, boolean isStrong) {
        this.debugName = name;
        this.isStrong = isStrong;
    }

    public boolean isStrong() {
        return this.isStrong;
    }

    public String toString() {
        return this.debugName;
    }

    public static class CompoundConstraintPosition
    extends ConstraintPosition {
        private final Collection<ConstraintPosition> positions;

        public CompoundConstraintPosition(Collection<ConstraintPosition> positions) {
            super("COMPOUND_CONSTRAINT_POSITION", CompoundConstraintPosition.hasConstraint(positions, true));
            this.positions = positions;
        }

        public boolean consistsOfOnlyStrongConstraints() {
            return !CompoundConstraintPosition.hasConstraint(this.positions, false);
        }

        private static boolean hasConstraint(@NotNull Collection<ConstraintPosition> positions, final boolean strong) {
            if (positions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positions", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintPosition$CompoundConstraintPosition", "hasConstraint"));
            }
            return KotlinPackage.any(positions, new Function1<ConstraintPosition, Boolean>(){

                @Override
                public Boolean invoke(ConstraintPosition constraintPosition) {
                    return constraintPosition.isStrong() == strong;
                }
            });
        }
    }
}

