/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ReifiedTypeParameterSubstitutionCheck
implements CallResolverExtension {
    @Override
    public <F extends CallableDescriptor> void run(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/ReifiedTypeParameterSubstitutionCheck", "run"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ReifiedTypeParameterSubstitutionCheck", "run"));
        }
        Map<TypeParameterDescriptor, JetType> typeArguments = resolvedCall.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, JetType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor parameter = entry.getKey();
            JetType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescription = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified()) continue;
            if (argumentDeclarationDescription instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescription).isReified()) {
                context2.trace.report(Errors.TYPE_PARAMETER_AS_REIFIED.on(ReifiedTypeParameterSubstitutionCheck.getCallElement(context2), parameter));
                continue;
            }
            if (!KotlinBuiltIns.getInstance().isNothingOrNullableNothing(argument)) continue;
            context2.trace.report(Errors.REIFIED_TYPE_NOTHING_SUBSTITUTION.on(ReifiedTypeParameterSubstitutionCheck.getCallElement(context2), argument));
        }
    }

    @NotNull
    private static PsiElement getCallElement(@NotNull BasicCallResolutionContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ReifiedTypeParameterSubstitutionCheck", "getCallElement"));
        }
        JetExpression callee = context2.call.getCalleeExpression();
        JetElement jetElement = callee != null ? callee : context2.call.getCallElement();
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ReifiedTypeParameterSubstitutionCheck", "getCallElement"));
        }
        return jetElement;
    }
}

