/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterList;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DelegatedPropertyResolver;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.source.SourcePackage;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.Flexibility;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.storage.StorageManager;

public class DescriptorResolver {
    public static final Name COPY_METHOD_NAME = Name.identifier("copy");
    private static final Set<JetModifierKeywordToken> MODIFIERS_ILLEGAL_ON_PARAMETERS = Sets.newHashSet();
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private StorageManager storageManager;

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setDelegatedPropertyResolver(@NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setDelegatedPropertyResolver"));
        }
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    @Inject
    public void setStorageManager(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setStorageManager"));
        }
        this.storageManager = storageManager;
    }

    public void resolveMutableClassDescriptor(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull JetClass classElement, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        JetTypeParameterList typeParameterList;
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveMutableClassDescriptor"));
        }
        if (classElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classElement", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveMutableClassDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveMutableClassDescriptor"));
        }
        List typeParameters = classElement.getTypeParameters();
        ArrayList<TypeParameterDescriptor> typeParameterDescriptors2 = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
        if (descriptor.getKind() == ClassKind.ENUM_CLASS && (typeParameterList = classElement.getTypeParameterList()) != null) {
            trace.report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
        }
        int index2 = 0;
        for (JetTypeParameter typeParameter : typeParameters) {
            if (!topDownAnalysisParameters.isLazy()) {
                AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
            }
            TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(descriptor, Annotations.EMPTY, typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index2, SourcePackage.toSourceElement(typeParameter));
            trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
            typeParameterDescriptors2.add(typeParameterDescriptor);
            ++index2;
        }
        descriptor.setTypeParameterDescriptors(typeParameterDescriptors2);
        Modality defaultModality = descriptor.getKind() == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
        descriptor.setModality(ModifiersChecker.resolveModalityFromModifiers(classElement, defaultModality));
        descriptor.setVisibility(ModifiersChecker.resolveVisibilityFromModifiers(classElement, ModifiersChecker.getDefaultClassVisibility(descriptor)));
        trace.record(BindingContext.CLASS, classElement, descriptor);
    }

    public void resolveSupertypesForMutableClassDescriptor(@NotNull JetClassOrObject jetClass, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypesForMutableClassDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypesForMutableClassDescriptor"));
        }
        for (JetType supertype : this.resolveSupertypes(descriptor.getScopeForClassHeaderResolution(), descriptor, jetClass, trace)) {
            descriptor.addSupertype(supertype);
        }
    }

    public List<JetType> resolveSupertypes(@NotNull JetScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetClassOrObject jetClass, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        ArrayList<JetType> supertypes2 = Lists.newArrayList();
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        Collection<JetType> declaredSupertypes = this.resolveDelegationSpecifiers(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (JetType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !this.containsClass(supertypes2)) {
            supertypes2.add(0, KotlinBuiltIns.getInstance().getEnumType(classDescriptor.getDefaultType()));
        }
        if (supertypes2.isEmpty()) {
            JetType defaultSupertype = this.getDefaultSupertype(jetClass, trace);
            DescriptorResolver.addValidSupertype(supertypes2, defaultSupertype);
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<JetType> supertypes2, JetType declaredSupertype) {
        if (!declaredSupertype.isError()) {
            supertypes2.add(declaredSupertype);
        }
    }

    private boolean containsClass(Collection<JetType> result2) {
        for (JetType type2 : result2) {
            ClassifierDescriptor descriptor = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor instanceof ClassDescriptor) || ((ClassDescriptor)descriptor).getKind() == ClassKind.TRAIT) continue;
            return true;
        }
        return false;
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass, BindingTrace trace) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = JetStubbedPsiUtil.getContainingDeclaration(jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(jetClass.getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        if (jetClass instanceof JetClass && ((JetClass)jetClass).isAnnotation()) {
            return KotlinBuiltIns.getInstance().getAnnotationType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(JetScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegationSpecifiers"));
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetType> result2 = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                result2.add(resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds));
                JetTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static JetTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNullableSupertypeAndStripQuestionMarks"));
        }
        while (typeElement instanceof JetNullableType) {
            JetNullableType nullableType = (JetNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof JetNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (typeElement instanceof JetUserType) {
            JetUserType userType = (JetUserType)typeElement;
            List<JetTypeProjection> typeArguments = userType.getTypeArguments();
            for (JetTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
            }
        }
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptorWithAnnotationArguments(@NotNull DeclarationDescriptor containingDescriptor, @NotNull JetScope scope2, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = this.resolveFunctionDescriptor(containingDescriptor, scope2, function, trace, dataFlowInfo, this.annotationResolver.resolveAnnotationsWithArguments(scope2, function.getModifierList(), trace));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull JetScope scope2, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = this.resolveFunctionDescriptor(containingDescriptor, scope2, function, trace, dataFlowInfo, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function.getModifierList(), trace));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, final @NotNull JetScope scope2, final @NotNull JetNamedFunction function, final @NotNull BindingTrace trace, final @NotNull DataFlowInfo dataFlowInfo, @NotNull Annotations annotations2) {
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        final SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(containingDescriptor, annotations2, JetPsiUtil.safeName(function.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(function));
        WritableScopeImpl innerScope = new WritableScopeImpl(scope2, functionDescriptor, new TraceBasedRedeclarationHandler(trace), "Function descriptor header scope");
        innerScope.addLabeledDeclaration(functionDescriptor);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2 = this.resolveTypeParametersForCallableDescriptor(functionDescriptor, innerScope, function.getTypeParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.resolveGenericBounds(function, functionDescriptor, innerScope, typeParameterDescriptors2, trace);
        JetType receiverType = null;
        JetTypeReference receiverTypeRef = function.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            JetScope scopeForReceiver = function.hasTypeParameterListBeforeFunctionName() ? innerScope : scope2;
            receiverType = this.typeResolver.resolveType(scopeForReceiver, receiverTypeRef, trace, true);
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = this.resolveValueParameters(functionDescriptor, innerScope, function.getValueParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.READING);
        JetTypeReference returnTypeRef = function.getTypeReference();
        JetType returnType = returnTypeRef != null ? this.typeResolver.resolveType(innerScope, returnTypeRef, trace, true) : (function.hasBlockBody() ? KotlinBuiltIns.getInstance().getUnitType() : (function.hasBody() ? DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

            @Override
            public JetType invoke() {
                JetType type2 = DescriptorResolver.this.expressionTypingServices.getBodyExpressionType(trace, scope2, dataFlowInfo, function, functionDescriptor);
                return DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, function, type2, trace);
            }
        }) : ErrorUtils.createErrorType("No type, no body")));
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(function, DescriptorResolver.getDefaultModality(containingDescriptor, function.hasBody()));
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function, DescriptorResolver.getDefaultVisibility(function, containingDescriptor));
        functionDescriptor.initialize(receiverType, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDescriptor), typeParameterDescriptors2, (List)valueParameterDescriptors, returnType, modality, visibility);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        Name functionName = DataClassUtilsPackage.createComponentName(parameterIndex);
        JetType returnType = property2.getType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, functionName, CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), Collections.emptyList(), returnType, Modality.FINAL, property2.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        JetType returnType = classDescriptor.getDefaultType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : constructorParameters) {
            PropertyDescriptor propertyDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
            boolean declaresDefaultValue = propertyDescriptor != null;
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, parameter.getIndex(), parameter.getAnnotations(), parameter.getName(), parameter.getType(), declaresDefaultValue, parameter.getVarargElementType(), SourceElement.NO_SOURCE);
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), parameterDescriptors, returnType, Modality.FINAL, classDescriptor.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    public static Visibility getDefaultVisibility(JetModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        JetModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.INTERNAL) : (containingDescriptor instanceof FunctionDescriptor ? Visibilities.LOCAL : Visibilities.INTERNAL);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.TRAIT;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, WritableScope parameterScope, List<JetParameter> valueParameters, BindingTrace trace) {
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>();
        for (int i = 0; i < valueParameters.size(); ++i) {
            JetType type2;
            JetParameter valueParameter = valueParameters.get(i);
            JetTypeReference typeReference = valueParameter.getTypeReference();
            if (typeReference == null) {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on(valueParameter));
                type2 = ErrorUtils.createErrorType("Type annotation was missing");
            } else {
                type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                DescriptorResolver.checkParameterHasNoValOrVar(trace, valueParameter, Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
                DescriptorResolver.checkParameterHasNoModifier(trace, valueParameter);
            } else {
                DescriptorResolver.checkConstructorParameterHasNoModifier(trace, valueParameter);
            }
            ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, i, type2, trace);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result2.add(valueParameterDescriptor);
        }
        ArrayList<ValueParameterDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameters"));
        }
        return arrayList;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(JetScope scope2, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace) {
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = DescriptorResolver.resolveValueParameterDescriptor(declarationDescriptor, valueParameter, index2, type2, trace, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, valueParameter.getModifierList(), trace));
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptorWithAnnotationArguments(JetScope scope2, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace) {
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = DescriptorResolver.resolveValueParameterDescriptor(declarationDescriptor, valueParameter, index2, type2, trace, this.annotationResolver.resolveAnnotationsWithArguments(scope2, valueParameter.getModifierList(), trace));
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptorWithAnnotationArguments"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private static ValueParameterDescriptorImpl resolveValueParameterDescriptor(DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace, Annotations annotations2) {
        JetType varargElementType = null;
        JetType variableType = type2;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = DescriptorResolver.getVarargParameterType(type2);
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(declarationDescriptor, null, index2, annotations2, JetPsiUtil.safeName(valueParameter.getName()), variableType, valueParameter.hasDefaultValue(), varargElementType, SourcePackage.toSourceElement(valueParameter));
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private static JetType getVarargParameterType(@NotNull JetType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        JetType primitiveArrayType = KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(elementType);
        if (primitiveArrayType != null) {
            JetType jetType = primitiveArrayType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVarargParameterType"));
            }
            return jetType;
        }
        JetType jetType = KotlinBuiltIns.getInstance().getArrayType(Variance.INVARIANT, elementType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        return jetType;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, List<JetTypeParameter> typeParameters, BindingTrace trace) {
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result2.add(this.resolveTypeParameterForCallableDescriptor(containingDescriptor, extensibleScope, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, JetTypeParameter typeParameter, int index2, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            assert (!(containingDescriptor instanceof ClassifierDescriptor)) : "This method is intended for functions/properties";
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_OF_FUNCTION_OR_PROPERTY.on(typeParameter));
        }
        AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, Annotations.EMPTY, typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index2, SourcePackage.toSourceElement(typeParameter));
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        extensibleScope.addTypeParameterDescriptor(typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable JetClassOrObject object2, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        ConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, SourcePackage.toSourceElement(object2));
        if (object2 != null) {
            trace.record(BindingContext.CONSTRUCTOR, object2, constructorDescriptor);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        return constructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, JetScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        ArrayList<UpperBoundCheckerTask> deferredUpperBoundCheckerTasks = Lists.newArrayList();
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            JetType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(extendsBound, type2, false));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            DescriptorResolver.reportUnsupportedClassObjectConstraint(trace, constraint);
            JetSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(boundTypeReference, bound, constraint.isClassObjectConstraint()));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null || constraint.isClassObjectConstraint()) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration instanceof JetClass)) {
            for (UpperBoundCheckerTask checkerTask : deferredUpperBoundCheckerTasks) {
                DescriptorResolver.checkUpperBoundType(checkerTask.upperBound, checkerTask.upperBoundType, checkerTask.isClassObjectConstraint, trace);
            }
            this.checkNamesInConstraints(declaration, descriptor, scope2, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull JetTypeParameter typeParameter) {
        JetType classObjectType;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (KotlinBuiltIns.getInstance().isNothing(parameter.getUpperBoundsAsType())) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
        if ((classObjectType = parameter.getClassObjectType()) != null && KotlinBuiltIns.getInstance().isNothing(classObjectType)) {
            trace.report(Errors.CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, @NotNull JetScope scope2, @NotNull BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetTypeReference boundTypeReference;
            Name name;
            ClassifierDescriptor classifier2;
            JetSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier2 = scope2.getClassifier(name = nameExpression.getReferencedNameAsName())) instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor) continue;
            if (classifier2 != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void reportUnsupportedClassObjectConstraint(BindingTrace trace, JetTypeConstraint constraint) {
        if (constraint.isClassObjectConstraint()) {
            trace.report(Errors.UNSUPPORTED.on(constraint, "Class objects constraints are not supported yet"));
        }
    }

    public static void checkUpperBoundType(JetTypeReference upperBound, JetType upperBoundType, boolean isClassObjectConstraint, BindingTrace trace) {
        if (!TypeUtils.canHaveSubtypes(JetTypeChecker.DEFAULT, upperBoundType)) {
            if (isClassObjectConstraint) {
                trace.report(Errors.FINAL_CLASS_OBJECT_UPPER_BOUND.on(upperBound, upperBoundType));
            } else {
                trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
            }
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetScope scope2, @NotNull JetParameter parameter, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type2, trace, scope2);
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptor;
    }

    private JetType resolveParameterType(JetScope scope2, JetParameter parameter, BindingTrace trace) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            return DescriptorResolver.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetParameter parameter, @NotNull JetType type2, BindingTrace trace, @NotNull JetScope scope2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter.getModifierList(), trace), JetPsiUtil.safeName(parameter.getName()), type2, false, SourcePackage.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(JetScope scope2, JetVariableDeclaration variable, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope2.getContainingDeclaration();
        if (JetPsiUtil.isScriptDeclaration(variable)) {
            PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable.isVar(), JetPsiUtil.safeName(variable.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(variable));
            JetType type2 = this.getVariableType(propertyDescriptor, scope2, variable, dataFlowInfo, false, trace);
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            propertyDescriptor.setType(type2, Collections.emptyList(), receiverParameter, (JetType)null);
            DescriptorResolver.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
            if (propertyDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
            }
            return propertyDescriptorImpl;
        }
        VariableDescriptorImpl variableDescriptor = this.resolveLocalVariableDescriptorWithType(scope2, variable, null, trace);
        JetType type3 = this.getVariableType(variableDescriptor, scope2, variable, dataFlowInfo, false, trace);
        variableDescriptor.setOutType(type3);
        VariableDescriptorImpl variableDescriptorImpl = variableDescriptor;
        if (variableDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptorImpl;
    }

    private static void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && propertyDescriptor.getVisibility() != Visibilities.PRIVATE) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor);
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor);
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public VariableDescriptorImpl resolveLocalVariableDescriptorWithType(@NotNull JetScope scope2, @NotNull JetVariableDeclaration variable, @Nullable JetType type2, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), JetPsiUtil.safeName(variable.getName()), type2, variable.isVar(), SourcePackage.toSourceElement(variable));
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        LocalVariableDescriptor localVariableDescriptor = variableDescriptor;
        if (localVariableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        return localVariableDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2;
        JetScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        JetModifierList modifierList = property2.getModifierList();
        boolean isVar = property2.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property2);
        Modality modality = containingDeclaration instanceof ClassDescriptor ? ModifiersChecker.resolveModalityFromModifiers(property2, DescriptorResolver.getDefaultModality(containingDeclaration, hasBody)) : Modality.FINAL;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(property2, DescriptorResolver.getDefaultVisibility(property2, containingDeclaration));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace), modality, visibility, isVar, JetPsiUtil.safeName(property2.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(property2));
        JetType receiverType = null;
        List typeParameters = property2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors2 = Collections.emptyList();
        } else {
            WritableScopeImpl writableScope = new WritableScopeImpl(scope2, containingDeclaration, new TraceBasedRedeclarationHandler(trace), "Scope with type parameters of a property");
            typeParameterDescriptors2 = this.resolveTypeParametersForCallableDescriptor(propertyDescriptor, writableScope, typeParameters, trace);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property2, propertyDescriptor, writableScope, typeParameterDescriptors2, trace);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType);
        ReceiverParameterDescriptor implicitInitializerReceiver = property2.hasDelegate() ? ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER : receiverDescriptor;
        JetScope propertyScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, scope2, typeParameterDescriptors2, implicitInitializerReceiver, trace);
        JetType type2 = this.getVariableType(propertyDescriptor, propertyScope, property2, dataFlowInfo, true, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors2, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptorImpl getter = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        propertyDescriptor.initialize(getter, setter);
        trace.record(BindingContext.VARIABLE, property2, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    static boolean hasBody(JetProperty property2) {
        boolean hasBody = property2.hasDelegateExpressionOrInitializer();
        if (!hasBody) {
            JetPropertyAccessor getter = property2.getGetter();
            if (getter != null && getter.hasBody()) {
                hasBody = true;
            }
            JetPropertyAccessor setter = property2.getSetter();
            if (!hasBody && setter != null && setter.hasBody()) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull VariableDescriptorImpl variableDescriptor, final @NotNull JetScope scope2, final @NotNull JetVariableDeclaration variable, final @NotNull DataFlowInfo dataFlowInfo, boolean notLocal, final @NotNull BindingTrace trace) {
        boolean hasDelegate;
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        JetTypeReference propertyTypeRef = variable.getTypeReference();
        boolean bl = hasDelegate = variable instanceof JetProperty && ((JetProperty)variable).hasDelegateExpression();
        if (propertyTypeRef == null) {
            if (!variable.hasInitializer()) {
                JetProperty property2;
                if (hasDelegate && variableDescriptor instanceof PropertyDescriptor && (property2 = (JetProperty)variable).hasDelegateExpression()) {
                    DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return DescriptorResolver.this.resolveDelegatedPropertyType(property2, (PropertyDescriptor)((Object)variableDescriptor), scope2, property2.getDelegateExpression(), dataFlowInfo, trace);
                        }
                    });
                    if (deferredType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                    }
                    return deferredType;
                }
                if (!notLocal) {
                    trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on(variable));
                }
                JetType jetType = ErrorUtils.createErrorType("No type, no body");
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                }
                return jetType;
            }
            if (notLocal) {
                DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                    @Override
                    public JetType invoke() {
                        JetType initializerType = DescriptorResolver.this.resolveInitializerType(scope2, variable.getInitializer(), dataFlowInfo, trace);
                        DescriptorResolver.this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, initializerType, trace);
                        return DescriptorResolver.transformAnonymousTypeIfNeeded(variableDescriptor, variable, initializerType, trace);
                    }
                });
                if (deferredType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                }
                return deferredType;
            }
            JetType initializerType = this.resolveInitializerType(scope2, variable.getInitializer(), dataFlowInfo, trace);
            this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, initializerType, trace);
            JetType jetType = initializerType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
            }
            return jetType;
        }
        JetType type2 = this.typeResolver.resolveType(scope2, propertyTypeRef, trace, true);
        this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, type2, trace);
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        return jetType;
    }

    private void setConstantForVariableIfNeeded(@NotNull VariableDescriptorImpl variableDescriptor, final @NotNull JetScope scope2, final @NotNull JetVariableDeclaration variable, final @NotNull DataFlowInfo dataFlowInfo, final @NotNull JetType variableType, final @NotNull BindingTrace trace) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableType", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (!DescriptorUtils.shouldRecordInitializerForProperty(variableDescriptor, variableType)) {
            return;
        }
        if (!variable.hasInitializer()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializer(this.storageManager.createRecursionTolerantNullableLazyValue(new Function0<CompileTimeConstant<?>>(){

            @Override
            @Nullable
            public CompileTimeConstant<?> invoke() {
                JetType initializerType;
                JetExpression initializer = variable.getInitializer();
                CompileTimeConstant<? extends Object> constant = ConstantExpressionEvaluator.OBJECT$.evaluate(initializer, trace, initializerType = DescriptorResolver.this.expressionTypingServices.safeGetType(scope2, initializer, variableType, dataFlowInfo, trace));
                if (constant instanceof IntegerValueTypeConstant) {
                    return EvaluatePackage.createCompileTimeConstantWithType((IntegerValueTypeConstant)constant, initializerType);
                }
                return constant;
            }
        }, null));
    }

    @NotNull
    private JetType resolveDelegatedPropertyType(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope scope2, @NotNull JetExpression delegateExpression, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        JetType getterReturnType;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, scope2, trace);
        JetType type2 = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property2, propertyDescriptor, scope2, accessorScope, trace, dataFlowInfo);
        if (type2 != null && (getterReturnType = this.delegatedPropertyResolver.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, type2, trace, accessorScope)) != null) {
            JetType jetType = getterReturnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Type from delegate");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        return jetType;
    }

    @Nullable
    private static JetType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull JetNamedDeclaration declaration, @NotNull JetType type2, @NotNull BindingTrace trace) {
        boolean transformNeeded;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null || !DescriptorUtils.isAnonymousObject(classifierDescriptor)) {
            return type2;
        }
        boolean definedInClass = DescriptorUtils.getParentOfType(descriptor, ClassDescriptor.class) != null;
        boolean isLocal = DescriptorUtils.isLocal(descriptor);
        Visibility visibility = descriptor.getVisibility();
        boolean bl = transformNeeded = !isLocal && !visibility.isPublicAPI() && (!definedInClass || !Visibilities.PRIVATE.equals(visibility));
        if (transformNeeded) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                assert (type2.getArguments().isEmpty()) : "Object expression couldn't have any type parameters!";
                return type2.getConstructor().getSupertypes().iterator().next();
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        return type2;
    }

    @NotNull
    private JetType resolveInitializerType(@NotNull JetScope scope2, @NotNull JetExpression initializer, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        JetType jetType = this.expressionTypingServices.safeGetType(scope2, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        return jetType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        JetPropertyAccessor setter = property2.getSetter();
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter != null) {
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, setter.getModifierList(), trace);
            JetParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveModalityFromModifiers(setter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(setter, propertyDescriptor.getVisibility()), setter.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(setter));
            if (parameter != null) {
                JetType type2;
                JetTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    type2 = this.typeResolver.resolveType(scope2, typeReference, trace, true);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type2, inType)) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scope2, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property2.isVar()) {
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, !property2.hasDelegate());
        }
        if (!property2.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        if (getter != null) {
            JetType outType;
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, getter.getModifierList(), trace);
            JetType returnType = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
                if (outType != null && !TypeUtils.equalTypes(returnType, outType)) {
                    trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType(), outType));
                }
            }
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveModalityFromModifiers(getter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(getter, propertyDescriptor.getVisibility()), getter.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(getter));
            getterDescriptor.initialize(returnType);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, !property2.hasDelegate());
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    @NotNull
    private ConstructorDescriptorImpl createConstructorDescriptor(@NotNull JetScope scope2, @NotNull ClassDescriptor classDescriptor, boolean isPrimary, @Nullable JetModifierList modifierList, @NotNull JetDeclaration declarationToTrace, List<TypeParameterDescriptor> typeParameters, @NotNull List<JetParameter> valueParameters, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (declarationToTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationToTrace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        ConstructorDescriptorImpl constructorDescriptor = ConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace), isPrimary, SourcePackage.toSourceElement(declarationToTrace));
        trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        WritableScopeImpl parameterScope = new WritableScopeImpl(scope2, constructorDescriptor, new TraceBasedRedeclarationHandler(trace), "Scope with value parameters of a constructor");
        parameterScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        ConstructorDescriptorImpl constructor2 = constructorDescriptor.initialize(typeParameters, this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters, trace), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor)));
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters, trace);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructor2;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        return constructorDescriptorImpl;
    }

    @Nullable
    public ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull JetScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetClass classElement, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classElement", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            return null;
        }
        return this.createConstructorDescriptor(scope2, classDescriptor, true, classElement.getPrimaryConstructorModifierList(), classElement, classDescriptor.getTypeConstructor().getParameters(), classElement.getPrimaryConstructorParameters(), trace);
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull JetScope scope2, @NotNull JetParameter parameter, BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, valueParameter.getAnnotations(), ModifiersChecker.resolveModalityFromModifiers(parameter, Modality.FINAL), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(parameter));
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor) : null;
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type2, @NotNull BindingTrace trace) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2.isError()) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<JetTypeReference> jetTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (TypesPackage.isFlexible(type2)) {
            assert (jetTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + JetPsiUtil.getElementTextWithContext(typeReference);
            Flexibility flexibility = TypesPackage.flexibility(type2);
            DescriptorResolver.checkBounds(jetTypeArguments.get(0), flexibility.getLowerBound(), trace);
            DescriptorResolver.checkBounds(jetTypeArguments.get(1), flexibility.getUpperBound(), trace);
            return;
        }
        assert (jetTypeArguments.size() == arguments2.size()) : typeElement.getText() + ": " + jetTypeArguments + " - " + arguments2;
        TypeSubstitutor substitutor = TypeSubstitutor.create(type2);
        for (int i = 0; i < jetTypeArguments.size(); ++i) {
            JetTypeReference jetTypeArgument = jetTypeArguments.get(i);
            if (jetTypeArgument == null) continue;
            JetType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    public static void checkBounds(@NotNull JetTypeReference jetTypeArgument, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull BindingTrace trace) {
        if (jetTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArgument", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor.safeSubstitute(bound, Variance.INVARIANT);
            if (JetTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull JetScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope2);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "isInsideOuterClassOrItsSubclass"));
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull JetScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getContainingClass"));
        }
        return DescriptorUtils.getParentOfType(scope2.getContainingDeclaration(), ClassDescriptor.class, false);
    }

    public static void checkParameterHasNoValOrVar(@NotNull BindingTrace trace, @NotNull JetParameter parameter, @NotNull DiagnosticFactory1<PsiElement, JetKeywordToken> diagnosticFactory) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (diagnosticFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        ASTNode valOrVarNode = parameter.getValOrVarNode();
        if (valOrVarNode != null) {
            trace.report(diagnosticFactory.on(valOrVarNode.getPsi(), (JetKeywordToken)valOrVarNode.getElementType()));
        }
    }

    private static void checkConstructorParameterHasNoModifier(@NotNull BindingTrace trace, @NotNull JetParameter parameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConstructorParameterHasNoModifier"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConstructorParameterHasNoModifier"));
        }
        if (!parameter.hasValOrVarNode()) {
            DescriptorResolver.checkParameterHasNoModifier(trace, parameter);
        }
    }

    public static void checkParameterHasNoModifier(@NotNull BindingTrace trace, @NotNull JetParameter parameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        ModifiersChecker.reportIllegalModifiers(parameter.getModifierList(), MODIFIERS_ILLEGAL_ON_PARAMETERS, trace);
    }

    public static void resolvePackageHeader(@NotNull JetPackageDirective packageDirective, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        if (packageDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDirective", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        for (JetSimpleNameExpression nameExpression : packageDirective.getPackageNames()) {
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            PackageViewDescriptor packageView = module.getPackage(fqName2);
            assert (packageView != null) : "package not found: " + fqName2;
            trace.record(BindingContext.REFERENCE_TARGET, nameExpression, packageView);
            PackageViewDescriptor parentPackageView = packageView.getContainingDeclaration();
            assert (parentPackageView != null) : "package has no parent: " + packageView;
            trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, parentPackageView.getMemberScope());
        }
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace, @NotNull JetFile file) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        FqName fqName2 = file.getPackageFqName();
        Collection<JetFile> files = trace.get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files == null) {
            files = Sets.newIdentityHashSet();
        }
        files.add(file);
        trace.record(BindingContext.PACKAGE_TO_FILES, fqName2, files);
    }

    static {
        MODIFIERS_ILLEGAL_ON_PARAMETERS.addAll(Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY));
        MODIFIERS_ILLEGAL_ON_PARAMETERS.remove(JetTokens.VARARG_KEYWORD);
    }

    static final class UpperBoundCheckerTask {
        JetTypeReference upperBound;
        JetType upperBoundType;
        boolean isClassObjectConstraint;

        private UpperBoundCheckerTask(JetTypeReference upperBound, JetType upperBoundType, boolean classObjectConstraint) {
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
            this.isClassObjectConstraint = classObjectConstraint;
        }
    }
}

