/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.stubs.KotlinObjectStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinObjectStubImpl
extends KotlinStubBaseImpl<JetObjectDeclaration>
implements KotlinObjectStub {
    private final StringRef name;
    private final FqName fqName;
    private final StringRef[] superNames;
    private final boolean isTopLevel;
    private final boolean isClassObject;
    private final boolean isLocal;
    private final boolean isObjectLiteral;

    public KotlinObjectStubImpl(@NotNull StubElement parent, @Nullable StringRef name, @Nullable FqName fqName2, @NotNull StringRef[] superNames, boolean isTopLevel, boolean isClassObject, boolean isLocal, boolean isObjectLiteral) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinObjectStubImpl", "<init>"));
        }
        if (superNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superNames", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinObjectStubImpl", "<init>"));
        }
        super((StubElement<? extends PsiElement>)parent, (IStubElementType<? extends StubElement<? extends Object>, ? extends PsiElement>)JetStubElementTypes.OBJECT_DECLARATION);
        this.name = name;
        this.fqName = fqName2;
        this.superNames = superNames;
        this.isTopLevel = isTopLevel;
        this.isClassObject = isClassObject;
        this.isLocal = isLocal;
        this.isObjectLiteral = isObjectLiteral;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    @NotNull
    public List<String> getSuperNames() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (StringRef ref : this.superNames) {
            result2.add(ref.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinObjectStubImpl", "getSuperNames"));
        }
        return arrayList;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isClassObject() {
        return this.isClassObject;
    }

    @Override
    public boolean isObjectLiteral() {
        return this.isObjectLiteral;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }
}

