/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.stubs.KotlinFunctionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinFunctionStubImpl
extends KotlinStubBaseImpl<JetNamedFunction>
implements KotlinFunctionStub {
    private final StringRef nameRef;
    private final boolean isTopLevel;
    private final boolean isExtension;
    private final FqName fqName;
    private final boolean hasBlockBody;
    private final boolean hasBody;
    private final boolean hasTypeParameterListBeforeFunctionName;
    private final boolean probablyNothingType;

    public KotlinFunctionStubImpl(@NotNull StubElement parent, @Nullable StringRef nameRef, boolean isTopLevel, @Nullable FqName fqName2, boolean isExtension, boolean hasBlockBody, boolean hasBody, boolean hasTypeParameterListBeforeFunctionName, boolean probablyNothingType) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinFunctionStubImpl", "<init>"));
        }
        super((StubElement<? extends PsiElement>)parent, (IStubElementType<? extends StubElement<? extends Object>, ? extends PsiElement>)JetStubElementTypes.FUNCTION);
        if (isTopLevel && fqName2 == null) {
            throw new IllegalArgumentException("fqName shouldn't be null for top level functions");
        }
        this.nameRef = nameRef;
        this.fqName = fqName2;
        this.isTopLevel = isTopLevel;
        this.isExtension = isExtension;
        this.hasBlockBody = hasBlockBody;
        this.hasBody = hasBody;
        this.hasTypeParameterListBeforeFunctionName = hasTypeParameterListBeforeFunctionName;
        this.probablyNothingType = probablyNothingType;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.nameRef);
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isExtension() {
        return this.isExtension;
    }

    @Override
    public boolean hasBlockBody() {
        return this.hasBlockBody;
    }

    @Override
    public boolean hasBody() {
        return this.hasBody;
    }

    @Override
    public boolean hasTypeParameterListBeforeFunctionName() {
        return this.hasTypeParameterListBeforeFunctionName;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    public boolean isProbablyNothingType() {
        return this.probablyNothingType;
    }
}

