/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JetAnnotationEntryElementType
extends JetStubElementType<KotlinAnnotationEntryStub, JetAnnotationEntry> {
    public JetAnnotationEntryElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "<init>"));
        }
        super(debugName, JetAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    @Override
    public KotlinAnnotationEntryStub createStub(@NotNull JetAnnotationEntry psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "createStub"));
        }
        Name shortName = JetPsiUtil.getShortName(psi);
        String resultName = shortName != null ? shortName.asString() : psi.getText();
        boolean hasValueArguments = psi.getValueArgumentList() != null;
        return new KotlinAnnotationEntryStubImpl(parentStub, StringRef.fromString(resultName), hasValueArguments);
    }

    @Override
    public void serialize(@NotNull KotlinAnnotationEntryStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "serialize"));
        }
        dataStream.writeName(stub.getShortName());
        dataStream.writeBoolean(stub.hasValueArguments());
    }

    @Override
    @NotNull
    public KotlinAnnotationEntryStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "deserialize"));
        }
        StringRef text = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        KotlinAnnotationEntryStubImpl kotlinAnnotationEntryStubImpl = new KotlinAnnotationEntryStubImpl(parentStub, text, hasValueArguments);
        if (kotlinAnnotationEntryStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "deserialize"));
        }
        return kotlinAnnotationEntryStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetAnnotationEntryElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexAnnotation(stub, sink);
    }
}

