/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetCallableDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeConstraintList;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterList;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.jet.lexer.JetTokens;

public class JetParameter
extends JetNamedDeclarationStub<KotlinParameterStub>
implements JetCallableDeclaration {
    public JetParameter(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetParameter", "<init>"));
        }
        super(node);
    }

    public JetParameter(@NotNull KotlinParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetParameter", "<init>"));
        }
        super(stub, JetStubElementTypes.VALUE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetParameter", "accept"));
        }
        return visitor.visitParameter(this, data2);
    }

    @Override
    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }

    @Override
    @Nullable
    public JetTypeReference setTypeReference(@Nullable JetTypeReference typeRef) {
        return TypeRefHelpersPackage.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    public boolean hasDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasDefaultValue();
        }
        return this.getDefaultValue() != null;
    }

    @Nullable
    public JetExpression getDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasDefaultValue()) {
            return null;
        }
        boolean passedEQ = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JetTokens.EQ) {
                passedEQ = true;
            }
            if (!passedEQ || !(child.getPsi() instanceof JetExpression)) continue;
            return (JetExpression)child.getPsi();
        }
        return null;
    }

    public boolean isMutable() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.isMutable();
        }
        return this.findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(JetTokens.VARARG_KEYWORD);
    }

    public boolean hasValOrVarNode() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasValOrValNode();
        }
        return this.getValOrVarNode() != null;
    }

    @Nullable
    public ASTNode getValOrVarNode() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasValOrValNode()) {
            return null;
        }
        ASTNode val = this.getNode().findChildByType(JetTokens.VAL_KEYWORD);
        if (val != null) {
            return val;
        }
        return this.getNode().findChildByType(JetTokens.VAR_KEYWORD);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public boolean isLoopParameter() {
        return this.getParent() instanceof JetForExpression;
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeConstraintList getTypeConstraintList() {
        return null;
    }

    @Override
    @NotNull
    public List<JetTypeConstraint> getTypeConstraints() {
        List<JetTypeConstraint> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetParameter", "getTypeConstraints"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeParameter> getTypeParameters() {
        List<JetTypeParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetParameter", "getTypeParameters"));
        }
        return list;
    }
}

