/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinObjectStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetObjectDeclaration
extends JetNamedDeclarationStub<KotlinObjectStub>
implements JetClassOrObject {
    public JetObjectDeclaration(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "<init>"));
        }
        super(node);
    }

    public JetObjectDeclaration(@NotNull KotlinObjectStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "<init>"));
        }
        super(stub, JetStubElementTypes.OBJECT_DECLARATION);
    }

    @Override
    public String getName() {
        KotlinObjectStub stub = (KotlinObjectStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getName();
    }

    @Override
    public boolean isTopLevel() {
        KotlinObjectStub stub = (KotlinObjectStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof JetFile;
    }

    @Override
    public PsiElement getNameIdentifier() {
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getNameIdentifier();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "setName"));
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.setName(name);
    }

    @Override
    @Nullable
    public JetObjectDeclarationName getNameAsDeclaration() {
        return (JetObjectDeclarationName)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        if (this.isClassObject()) {
            PsiElement parent = this.getParentByStub();
            assert (parent instanceof JetDeclaration);
            return ((JetDeclaration)parent).getModifierList();
        }
        return super.getModifierList();
    }

    public boolean isClassObject() {
        KotlinObjectStub stub = (KotlinObjectStub)this.getStub();
        if (stub != null) {
            return stub.isClassObject();
        }
        PsiElement parent = this.getParent();
        return parent != null && parent.getNode().getElementType().equals(JetNodeTypes.CLASS_OBJECT);
    }

    @Nullable
    public JetClassObject getClassObjectElement() {
        if (!this.isClassObject()) {
            return null;
        }
        return (JetClassObject)this.getParentByStub();
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "hasModifier"));
        }
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    @Nullable
    public JetDelegationSpecifierList getDelegationSpecifierList() {
        return (JetDelegationSpecifierList)this.getStubOrPsiChild(JetStubElementTypes.DELEGATION_SPECIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetDelegationSpecifierList list = this.getDelegationSpecifierList();
        List<JetDelegationSpecifier> list2 = list != null ? list.getDelegationSpecifiers() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getDelegationSpecifiers"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetClassInitializer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getAnonymousInitializers"));
            }
            return list;
        }
        List<JetClassInitializer> list = body.getAnonymousInitializers();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getAnonymousInitializers"));
        }
        return list;
    }

    @Override
    public boolean hasPrimaryConstructor() {
        return true;
    }

    @Override
    public JetClassBody getBody() {
        return (JetClassBody)this.getStubOrPsiChild(JetStubElementTypes.CLASS_BODY);
    }

    @Override
    public boolean isLocal() {
        KotlinObjectStub stub = (KotlinObjectStub)this.getStub();
        if (stub != null) {
            return stub.isLocal();
        }
        return JetPsiUtil.isLocal(this);
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getDeclarations"));
            }
            return list;
        }
        List<JetDeclaration> list = body.getDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getDeclarations"));
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "accept"));
        }
        return visitor.visitObjectDeclaration(this, data2);
    }

    public boolean isObjectLiteral() {
        KotlinObjectStub stub = (KotlinObjectStub)this.getStub();
        if (stub != null) {
            return stub.isObjectLiteral();
        }
        return this.getParent() instanceof JetObjectLiteralExpression;
    }

    @NotNull
    public PsiElement getObjectKeyword() {
        PsiElement psiElement = this.findChildByType(JetTokens.OBJECT_KEYWORD);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclaration", "getObjectKeyword"));
        }
        return psiElement;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        JetPsiUtil.deleteClass(this);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }
}

