/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationStub;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationUtil;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.PsiPackage;
import org.jetbrains.jet.lang.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetTokens;

abstract class JetNamedDeclarationStub<T extends KotlinStubWithFqName>
extends JetDeclarationStub<T>
implements JetNamedDeclaration {
    public JetNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetNamedDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "<init>"));
        }
        super(node);
    }

    @Override
    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name = this.getName();
        return name != null ? Name.identifier(name) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name = JetPsiUtil.safeName(this.getName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "getNameAsSafeName"));
        }
        return name;
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "setName"));
        }
        return this.getNameIdentifier().replace(PsiPackage.JetPsiFactory(this).createNameIdentifier(name));
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JetElement containingClass;
        JetElement enclosingBlock = JetPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(enclosingBlock);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "getUseScope"));
            }
            return localSearchScope;
        }
        if (this.hasModifier(JetTokens.PRIVATE_KEYWORD) && (containingClass = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)this, JetClassOrObject.class)) != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(containingClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedDeclarationStub", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return JetNamedDeclarationUtil.getFQName(this);
    }
}

