/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinModifierListStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetToken;

public abstract class JetModifierList
extends JetElementImplStub<KotlinModifierListStub> {
    public JetModifierList(@NotNull KotlinModifierListStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetModifierList", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/jet/lang/psi/JetModifierList", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetModifierList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetModifierList", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetModifierList", "accept"));
        }
        return visitor.visitModifierList(this, data2);
    }

    @NotNull
    public List<JetAnnotation> getAnnotations() {
        List<JetAnnotation> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.ANNOTATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetModifierList", "getAnnotations"));
        }
        return list;
    }

    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        List<JetAnnotationEntry> entries = this.getStubOrPsiChildrenAsList(JetStubElementTypes.ANNOTATION_ENTRY);
        ArrayList<JetAnnotationEntry> answer = entries.isEmpty() ? null : Lists.newArrayList(entries);
        for (JetAnnotation annotation2 : this.getAnnotations()) {
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.addAll(annotation2.getEntries());
        }
        List<JetAnnotationEntry> list = answer != null ? answer : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetModifierList", "getAnnotationEntries"));
        }
        return list;
    }

    public boolean hasModifier(@NotNull JetModifierKeywordToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/jet/lang/psi/JetModifierList", "hasModifier"));
        }
        KotlinModifierListStub stub = (KotlinModifierListStub)this.getStub();
        if (stub != null) {
            return stub.hasModifier(token);
        }
        return this.getModifierNode(token) != null;
    }

    @Nullable
    public PsiElement getModifier(@NotNull JetModifierKeywordToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/jet/lang/psi/JetModifierList", "getModifier"));
        }
        return this.findChildByType(token);
    }

    @Nullable
    public ASTNode getModifierNode(@NotNull JetToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/jet/lang/psi/JetModifierList", "getModifierNode"));
        }
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (node.getElementType() != token) continue;
            return node;
        }
        return null;
    }
}

