/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetFunctionTypeReceiver;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetFunctionType
extends JetElementImplStub<KotlinPlaceHolderStub<JetFunctionType>>
implements JetTypeElement {
    public static final JetToken RETURN_TYPE_SEPARATOR = JetTokens.ARROW;

    public JetFunctionType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetFunctionType", "<init>"));
        }
        super(node);
    }

    public JetFunctionType(@NotNull KotlinPlaceHolderStub<JetFunctionType> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetFunctionType", "<init>"));
        }
        super(stub, JetStubElementTypes.FUNCTION_TYPE);
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<JetTypeReference> result2 = Lists.newArrayList();
        JetTypeReference receiverTypeRef = this.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            result2.add(receiverTypeRef);
        }
        for (JetParameter jetParameter : this.getParameters()) {
            result2.add(jetParameter.getTypeReference());
        }
        JetTypeReference returnTypeRef = this.getReturnTypeReference();
        if (returnTypeRef != null) {
            result2.add(returnTypeRef);
        }
        ArrayList<JetTypeReference> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionType", "getTypeArgumentsAsTypes"));
        }
        return arrayList;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFunctionType", "accept"));
        }
        return visitor.visitFunctionType(this, data2);
    }

    @Nullable
    public JetParameterList getParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @NotNull
    public List<JetParameter> getParameters() {
        JetParameterList list = this.getParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionType", "getParameters"));
        }
        return list2;
    }

    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        JetFunctionTypeReceiver receiverDeclaration = (JetFunctionTypeReceiver)this.getStubOrPsiChild(JetStubElementTypes.FUNCTION_TYPE_RECEIVER);
        if (receiverDeclaration == null) {
            return null;
        }
        return receiverDeclaration.getTypeReference();
    }

    @Nullable
    public JetTypeReference getReturnTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }
}

