/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImplStub;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpressionImpl;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetToken;

public class JetDotQualifiedExpression
extends JetExpressionImplStub<KotlinPlaceHolderStub<JetDotQualifiedExpression>>
implements JetQualifiedExpression {
    private static final Logger LOG = Logger.getInstance(JetDotQualifiedExpression.class);

    public JetDotQualifiedExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "<init>"));
        }
        super(node);
    }

    public JetDotQualifiedExpression(@NotNull KotlinPlaceHolderStub<JetDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "<init>"));
        }
        super(stub, JetStubElementTypes.DOT_QUALIFIED_EXPRESSION);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "accept"));
        }
        return visitor.visitDotQualifiedExpression(this, data2);
    }

    @Override
    @NotNull
    public JetExpression getReceiverExpression() {
        JetExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null) {
            JetExpression jetExpression = childExpressionsByStub[0];
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "getReceiverExpression"));
            }
            return jetExpression;
        }
        JetExpression jetExpression = JetQualifiedExpressionImpl.INSTANCE$.getReceiverExpression(this);
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "getReceiverExpression"));
        }
        return jetExpression;
    }

    @Override
    @Nullable
    public JetExpression getSelectorExpression() {
        JetExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null && childExpressionsByStub.length == 2) {
            return childExpressionsByStub[1];
        }
        return JetQualifiedExpressionImpl.INSTANCE$.getSelectorExpression(this);
    }

    @Nullable
    private JetExpression[] getChildExpressionsByStub(@NotNull KotlinPlaceHolderStub<JetDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "getChildExpressionsByStub"));
        }
        if (stub.getParentStubOfType(JetImportDirective.class) == null && stub.getParentStubOfType(JetPackageDirective.class) == null) {
            LOG.error("JetDotQualifiedExpression should only have stubs inside import or package directives.\n Stubs were created for:\n " + this.getText() + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        JetExpression[] expressions = (JetExpression[])stub.getChildrenByType(JetStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, JetExpression.ARRAY_FACTORY);
        if (expressions.length < 1 || expressions.length > 2) {
            LOG.error("Invalid stub structure. DOT_QUALIFIED_EXPRESSION must have one or two children. Was: " + expressions.length + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        return expressions;
    }

    @Override
    @NotNull
    public ASTNode getOperationTokenNode() {
        ASTNode aSTNode = JetQualifiedExpressionImpl.INSTANCE$.getOperationTokenNode(this);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "getOperationTokenNode"));
        }
        return aSTNode;
    }

    @Override
    @NotNull
    public JetToken getOperationSign() {
        JetToken jetToken = JetQualifiedExpressionImpl.INSTANCE$.getOperationSign(this);
        if (jetToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDotQualifiedExpression", "getOperationSign"));
        }
        return jetToken;
    }
}

