/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.annotations;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class AnnotationDescriptorImpl
implements AnnotationDescriptor {
    private final JetType annotationType;
    private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments;

    public AnnotationDescriptorImpl(@NotNull JetType annotationType, @NotNull Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments2) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        this.annotationType = annotationType;
        this.valueArguments = Collections.unmodifiableMap(valueArguments2);
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.annotationType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getType"));
        }
        return jetType;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> getValueArgument(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getValueArgument"));
        }
        return this.getAllValueArguments().get(valueParameterDescriptor);
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, CompileTimeConstant<?>> getAllValueArguments() {
        Map<ValueParameterDescriptor, CompileTimeConstant<?>> map = this.valueArguments;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getAllValueArguments"));
        }
        return map;
    }

    public String toString() {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderAnnotation(this);
    }
}

