/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final TObjectIntHashMap<T> interned;

    public Interner(Interner<T> parent, @NotNull TObjectHashingStrategy<T> hashing) {
        if (hashing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashing", "org/jetbrains/jet/descriptors/serialization/Interner", "<init>"));
        }
        this.parent = parent;
        this.firstIndex = parent != null ? parent.interned.size() + parent.firstIndex : 0;
        this.interned = new TObjectIntHashMap<T>(hashing);
    }

    public Interner(@NotNull TObjectHashingStrategy<T> hashing) {
        if (hashing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashing", "org/jetbrains/jet/descriptors/serialization/Interner", "<init>"));
        }
        this(null, hashing);
    }

    public Interner(@Nullable Interner<T> parent) {
        this(parent, TObjectHashingStrategy.CANONICAL);
    }

    public Interner() {
        this((Interner)null);
    }

    private int find(@NotNull T obj) {
        int index2;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/jet/descriptors/serialization/Interner", "find"));
        }
        assert (this.parent == null || this.parent.interned.size() + this.parent.firstIndex == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && (index2 = super.find(obj)) >= 0) {
            return index2;
        }
        if (this.interned.contains(obj)) {
            return this.interned.get(obj);
        }
        return -1;
    }

    public int intern(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/jet/descriptors/serialization/Interner", "intern"));
        }
        int index2 = this.find(obj);
        if (index2 >= 0) {
            return index2;
        }
        index2 = this.firstIndex + this.interned.size();
        this.interned.put(obj, index2);
        return index2;
    }

    @NotNull
    public List<T> getAllInternedObjects() {
        List<Object> list = KotlinPackage.toSortedListBy(this.interned.keys(), new Function1<T, Integer>(){

            @Override
            public Integer invoke(T key) {
                return Interner.this.interned.get(key);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/Interner", "getAllInternedObjects"));
        }
        return list;
    }
}

