/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.org.objectweb.asm.Type;

public class Parameters
implements Iterable<ParameterInfo> {
    private final List<ParameterInfo> real;
    private final List<CapturedParamInfo> captured;

    public Parameters(List<ParameterInfo> real, List<CapturedParamInfo> captured) {
        this.real = real;
        this.captured = captured;
    }

    public List<ParameterInfo> getReal() {
        return this.real;
    }

    public List<CapturedParamInfo> getCaptured() {
        return this.captured;
    }

    public int totalSize() {
        return this.real.size() + this.captured.size();
    }

    public ParameterInfo get(int index2) {
        if (index2 < this.real.size()) {
            return this.real.get(index2);
        }
        return this.captured.get(index2 - this.real.size());
    }

    @Override
    @NotNull
    public Iterator<ParameterInfo> iterator() {
        Iterator<ParameterInfo> iterator2 = Iterables.concat(this.real, this.captured).iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/Parameters", "iterator"));
        }
        return iterator2;
    }

    public static List<CapturedParamInfo> shiftAndAddStubs(List<CapturedParamInfo> capturedParams, int realSize) {
        ArrayList<CapturedParamInfo> result2 = new ArrayList<CapturedParamInfo>();
        for (CapturedParamInfo capturedParamInfo : capturedParams) {
            CapturedParamInfo newInfo = capturedParamInfo.newIndex(result2.size() + realSize);
            result2.add(newInfo);
            if (capturedParamInfo.getType().getSize() != 2) continue;
            result2.add(CapturedParamInfo.STUB);
        }
        return result2;
    }

    public static List<ParameterInfo> addStubs(List<ParameterInfo> params) {
        ArrayList<ParameterInfo> result2 = new ArrayList<ParameterInfo>();
        for (ParameterInfo newInfo : params) {
            result2.add(newInfo);
            if (newInfo.getType().getSize() != 2) continue;
            result2.add(ParameterInfo.STUB);
        }
        return result2;
    }

    public ArrayList<Type> getCapturedTypes() {
        ArrayList<Type> result2 = new ArrayList<Type>();
        for (CapturedParamInfo info : this.captured) {
            if (info == CapturedParamInfo.STUB) continue;
            result2.add(info.getType());
        }
        return result2;
    }
}

