/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ArgumentGenerator;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallGenerator;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<Type> valueParameterTypes) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (valueParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterTypes", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters;
        this.valueParameterTypes = valueParameterTypes;
        assert (valueParameters.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters.size() + " != " + valueParameterTypes.size();
    }

    @Override
    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "generateExpression"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        ValueArgument valueArgument = argument.getValueArgument();
        assert (valueArgument != null);
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression, type2);
    }

    @Override
    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "generateDefault"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        AsmUtil.pushDefaultValueOnStack(type2, this.codegen.v);
        this.callGenerator.afterParameterPut(type2, null, parameter);
    }

    @Override
    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/CallBasedArgumentGenerator", "generateVararg"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        this.codegen.genVarargs(argument, parameter.getType());
        this.callGenerator.afterParameterPut(type2, null, parameter);
    }
}

