/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import org.jetbrains.annotations.NotNull;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement type2 = this.myTypeElements[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(type2.getText());
        }
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "PsiReferenceParameterList";
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightReferenceParameterList", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement typeElement = this.myTypeElements[i];
            elements[i] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    @Override
    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightReferenceParameterList", "getTypeParameterElements"));
        }
        return this.myTypeElements;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightReferenceParameterList", "getTypeArguments"));
        }
        return psiTypeArray;
    }
}

