/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableNotNullManager {
    private static final Logger LOG = Logger.getInstance("#" + NullableNotNullManager.class.getName());
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    private String checkContainer(PsiAnnotation annotation2, boolean acceptContainer) {
        if (annotation2 == null) {
            return null;
        }
        if (!acceptContainer && this.isContainerAnnotation(annotation2)) {
            return null;
        }
        return annotation2.getQualifiedName();
    }

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNullableAnnotation"));
        }
        return this.findNullabilityAnnotation(owner, checkBases, true);
    }

    public boolean isContainerAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/NullableNotNullManager", "isContainerAnnotation"));
        }
        PsiAnnotation.TargetType[] acceptAnyTarget = PsiAnnotation.TargetType.values();
        return NullableNotNullManager.isNullabilityDefault(anno, true, acceptAnyTarget) || NullableNotNullManager.isNullabilityDefault(anno, false, acceptAnyTarget);
    }

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNotNullAnnotation"));
        }
        return this.findNullabilityAnnotation(owner, checkBases, false);
    }

    public PsiAnnotation copyNotNullAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNotNullAnnotation(owner, false));
    }

    public PsiAnnotation copyNullableAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNullableAnnotation(owner, false));
    }

    private PsiAnnotation copyAnnotation(PsiModifierListOwner owner, PsiAnnotation annotation2) {
        String notNull = this.checkContainer(annotation2, false);
        if (notNull != null) {
            return JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + notNull, owner);
        }
        return null;
    }

    @Nullable
    private PsiAnnotation findNullabilityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable2) {
        PsiAnnotation annotation2;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "findNullabilityAnnotation"));
        }
        HashSet<String> qNames = ContainerUtil.newHashSet(nullable2 ? this.getNullables() : this.getNotNulls());
        PsiAnnotation psiAnnotation = annotation2 = checkBases && (owner instanceof PsiClass || owner instanceof PsiMethod) ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
        if (annotation2 != null) {
            return annotation2;
        }
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (type2 == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated(owner, nullable2 ? Arrays.asList(DEFAULT_NOT_NULLS) : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
            return null;
        }
        return NullableNotNullManager.findNullabilityDefaultInHierarchy(owner, nullable2);
    }

    @Nullable
    private static PsiType getOwnerType(PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findNullabilityDefaultInHierarchy(PsiModifierListOwner owner, boolean nullable2) {
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation2;
            if (element instanceof PsiModifierListOwner && (annotation2 = NullableNotNullManager.getNullabilityDefault((PsiModifierListOwner)element, nullable2, placeTargetTypes)) != null) {
                return annotation2;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return psiPackage == null ? null : NullableNotNullManager.getNullabilityDefault(psiPackage, nullable2, placeTargetTypes);
        }
        return null;
    }

    private static PsiAnnotation getNullabilityDefault(@NotNull PsiModifierListOwner container, boolean nullable2, PsiAnnotation.TargetType[] placeTargetTypes) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/NullableNotNullManager", "getNullabilityDefault"));
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation2 : modifierList.getAnnotations()) {
            if (!NullableNotNullManager.isNullabilityDefault(annotation2, nullable2, placeTargetTypes)) continue;
            return annotation2;
        }
        return null;
    }

    private static boolean isNullabilityDefault(@NotNull PsiAnnotation annotation2, boolean nullable2, PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiElement declaration;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/NullableNotNullManager", "isNullabilityDefault"));
        }
        PsiJavaCodeReferenceElement element = annotation2.getNameReferenceElement();
        PsiElement psiElement = declaration = element == null ? null : element.resolve();
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)declaration), nullable2 ? "javax.annotation.Nullable" : "javax.annotation.Nonnull", false, true)) {
            return false;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)declaration), true, "javax.annotation.meta.TypeQualifierDefault");
        if (tqDefault == null) {
            return false;
        }
        Set<PsiAnnotation.TargetType> required = AnnotationTargetUtil.extractRequiredAnnotationTargets(tqDefault.findAttributeValue(null));
        if (required == null) {
            return false;
        }
        return required.isEmpty() || ContainerUtil.intersects(required, Arrays.asList(placeTargetTypes));
    }

    @NotNull
    public List<String> getNullables() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNullables;
        if (jDOMExternalizableStringList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getNullables"));
        }
        return jDOMExternalizableStringList;
    }

    @NotNull
    public List<String> getNotNulls() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNotNulls;
        if (jDOMExternalizableStringList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getNotNulls"));
        }
        return jDOMExternalizableStringList;
    }
}

