/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetExpression;

public final class ErrorReportingUtils {
    private ErrorReportingUtils() {
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull JetExpression selector, @NotNull RuntimeException e) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "reportErrorWithLocation"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "reportErrorWithLocation"));
        }
        RuntimeException runtimeException = ErrorReportingUtils.reportErrorWithLocation(e, DiagnosticUtils.atLocation(selector));
        if (runtimeException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "reportErrorWithLocation"));
        }
        return runtimeException;
    }

    @NotNull
    private static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull String location) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "reportErrorWithLocation"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "reportErrorWithLocation"));
        }
        throw new RuntimeException(e.getMessage() + " at " + location, e);
    }

    @NotNull
    public static String message(@NotNull PsiElement expression, @NotNull String messageText) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        if (messageText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageText", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        String string = messageText + " at " + DiagnosticUtils.atLocation(expression) + ".";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        return string;
    }

    @NotNull
    public static String message(@NotNull DeclarationDescriptor descriptor, @NotNull String explainingMessage) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        if (explainingMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explainingMessage", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        String string = explainingMessage + " at " + DiagnosticUtils.atLocation(descriptor) + ".";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        return string;
    }

    @NotNull
    public static String message(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        String string = "Error at " + DiagnosticUtils.atLocation(element) + ".";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/ErrorReportingUtils", "message"));
        }
        return string;
    }
}

