/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context2, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression value) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        JsStatement jsStatement = TranslationUtils.assignmentToBackingField(context2, descriptor, value).makeStmt();
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        return jsStatement;
    }

    @Nullable
    public static JsStatement generateInitializerForDelegate(@NotNull TranslationContext context2, @NotNull JetProperty property2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForDelegate"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateInitializerForDelegate"));
        }
        JetExpression delegate2 = property2.getDelegateExpression();
        if (delegate2 != null) {
            JsExpression value = Translation.translateAsExpression(delegate2, context2);
            String name = property2.getName();
            assert (name != null) : "Delegate property must have name";
            return JsAstUtils.defineSimpleProperty(Namer.getDelegateName(name), value);
        }
        return null;
    }

    public static void generateObjectInitializer(@NotNull JetObjectDeclaration declaration, @NotNull List<JsStatement> initializers, @NotNull TranslationContext context2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        if (initializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializers", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        JsExpression value = ClassTranslator.generateObjectLiteral(declaration, context2);
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), declaration);
        JsExpression expression = JsAstUtils.assignment(new JsNameRef(descriptor.getName().asString(), (JsExpression)JsLiteral.THIS), value);
        initializers.add(expression.makeStmt());
    }

    public static JsPropertyInitializer createClassObjectInitializer(JsExpression value, TranslationContext context2) {
        JsStringLiteral classObjectInitStr = context2.program().getStringLiteral(Namer.getNameForClassObjectInitializer());
        return new JsPropertyInitializer(classObjectInitStr, value);
    }
}

