/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.inline;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataPackage;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.types.lang.InlineStrategy;
import org.jetbrains.k2js.inline.FunctionInlineMutator;
import org.jetbrains.k2js.inline.InlineableResult;
import org.jetbrains.k2js.inline.clean.CleanPackage;
import org.jetbrains.k2js.inline.context.FunctionContext;
import org.jetbrains.k2js.inline.context.InliningContext;
import org.jetbrains.k2js.inline.context.InsertionPoint;
import org.jetbrains.k2js.inline.context.NamingContext;
import org.jetbrains.k2js.inline.context.StatementContext;
import org.jetbrains.k2js.inline.exception.InlineRecursionException;
import org.jetbrains.k2js.inline.util.UtilPackage;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final IdentityHashMap<JsName, JsFunction> functions;
    private final Stack<JsInliningContext> inliningContexts = new Stack();
    private final Set<JsFunction> processedFunctions = UtilPackage.IdentitySet();
    private final Set<JsFunction> inProcessFunctions = UtilPackage.IdentitySet();
    private boolean lastStatementWasShifted = false;

    public static JsProgram process(JsProgram program) {
        IdentityHashMap<JsName, JsFunction> functions2 = UtilPackage.collectNamedFunctions(program);
        JsInliner inliner = new JsInliner(functions2);
        inliner.accept(program);
        CleanPackage.removeUnusedFunctionDefinitions(program, functions2);
        return program;
    }

    JsInliner(IdentityHashMap<JsName, JsFunction> functions2) {
        this.functions = functions2;
    }

    @Override
    public boolean visit(JsFunction function, JsContext context2) {
        this.inliningContexts.push(new JsInliningContext(function));
        if (this.inProcessFunctions.contains(function)) {
            throw new InlineRecursionException();
        }
        this.inProcessFunctions.add(function);
        return super.visit(function, context2);
    }

    @Override
    public void endVisit(JsFunction function, JsContext context2) {
        super.endVisit(function, context2);
        CleanPackage.removeUnusedLocalFunctionDeclarations(function);
        this.processedFunctions.add(function);
        assert (this.inProcessFunctions.contains(function));
        this.inProcessFunctions.remove(function);
        this.inliningContexts.pop();
    }

    @Override
    public boolean visit(JsInvocation call, JsContext context2) {
        if (call == null) {
            return false;
        }
        if (JsInliner.shouldInline(call) && this.canInline(call)) {
            JsFunction definition = this.getFunctionContext().getFunctionDefinition(call);
            if (!this.processedFunctions.contains(definition)) {
                this.accept(definition);
            }
            this.inline(call, context2);
        }
        return !this.lastStatementWasShifted;
    }

    private void inline(@NotNull JsInvocation call, @NotNull JsContext context2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/k2js/inline/JsInliner", "inline"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/inline/JsInliner", "inline"));
        }
        JsInliningContext inliningContext = this.getInliningContext();
        FunctionContext functionContext = this.getFunctionContext();
        functionContext.declareFunctionConstructorCalls(call.getArguments());
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        StatementContext statementContext = inliningContext.getStatementContext();
        if (resultExpression == null) {
            statementContext.removeCurrentStatement();
        } else {
            context2.replaceMe(resultExpression);
        }
        statementContext.shiftCurrentStatementForward();
        InsertionPoint<JsStatement> insertionPoint = statementContext.getInsertionPoint();
        insertionPoint.insertAllAfter(JsAstUtils.flattenStatement(inlineableBody));
    }

    @Override
    protected <T extends JsNode> void doTraverse(T node, JsContext ctx) {
        if (node instanceof JsStatement) {
            this.lastStatementWasShifted = false;
        }
        if (!this.lastStatementWasShifted) {
            super.doTraverse(node, ctx);
        }
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        JsInliningContext jsInliningContext = this.inliningContexts.peek();
        if (jsInliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner", "getInliningContext"));
        }
        return jsInliningContext;
    }

    @NotNull
    FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getInliningContext().getFunctionContext();
        if (functionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner", "getFunctionContext"));
        }
        return functionContext;
    }

    private boolean canInline(@NotNull JsInvocation call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/k2js/inline/JsInliner", "canInline"));
        }
        FunctionContext functionContext = this.getFunctionContext();
        return functionContext.hasFunctionDefinition(call);
    }

    private static boolean shouldInline(@NotNull JsInvocation call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/k2js/inline/JsInliner", "shouldInline"));
        }
        InlineStrategy strategy = MetadataPackage.getInlineStrategy(call);
        return strategy != null && strategy.isInline();
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;

        JsInliningContext(JsFunction function) {
            this.functionContext = new FunctionContext(function, this){

                @Override
                @Nullable
                protected JsFunction lookUpStaticFunction(@Nullable JsName functionName) {
                    return (JsFunction)JsInliner.this.functions.get(functionName);
                }
            };
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            JsScope scope = this.getFunctionContext().getScope();
            InsertionPoint<JsStatement> insertionPoint = this.getStatementContext().getInsertionPoint();
            NamingContext namingContext = new NamingContext(scope, insertionPoint);
            if (namingContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner$JsInliningContext", "newNamingContext"));
            }
            return namingContext;
        }

        @Override
        @NotNull
        public StatementContext getStatementContext() {
            StatementContext statementContext = new StatementContext(){

                @Override
                @NotNull
                public JsContext getCurrentStatementContext() {
                    JsContext jsContext = JsInliner.this.getLastStatementLevelContext();
                    if (jsContext == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner$JsInliningContext$2", "getCurrentStatementContext"));
                    }
                    return jsContext;
                }

                @Override
                @NotNull
                protected JsStatement getEmptyStatement() {
                    JsEmpty jsEmpty = JsInliningContext.this.getFunctionContext().getEmpty();
                    if (jsEmpty == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner$JsInliningContext$2", "getEmptyStatement"));
                    }
                    return jsEmpty;
                }

                @Override
                public void shiftCurrentStatementForward() {
                    super.shiftCurrentStatementForward();
                    JsInliner.this.lastStatementWasShifted = true;
                }
            };
            if (statementContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner$JsInliningContext", "getStatementContext"));
            }
            return statementContext;
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            FunctionContext functionContext = this.functionContext;
            if (functionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/JsInliner$JsInliningContext", "getFunctionContext"));
            }
            return functionContext;
        }
    }
}

