/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.PsiPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.SmartCastUtils;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CaptureKind;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ExpressionTypingUtils {
    private final ExpressionTypingServices expressionTypingServices;
    private final CallResolver callResolver;

    public ExpressionTypingUtils(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull CallResolver resolver2) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "<init>"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "<init>"));
        }
        this.expressionTypingServices = expressionTypingServices;
        this.callResolver = resolver2;
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (type == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type);
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getTypeInfo(expression, context2).getType());
    }

    @NotNull
    protected static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        JetType type = ExpressionTypingUtils.safeGetType(facade.safeGetTypeInfo(expression, context2));
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, type);
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    public static JetType safeGetType(@NotNull JetTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        JetType type = typeInfo.getType();
        assert (type != null) : "safeGetType should be invoked on safe JetTypeInfo; safeGetTypeInfo should return @NotNull type";
        JetType jetType = type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        return jetType;
    }

    @NotNull
    public static WritableScopeImpl newWritableScopeImpl(ExpressionTypingContext context2, @NotNull String scopeDebugName) {
        if (scopeDebugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeDebugName", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        WritableScopeImpl scope = new WritableScopeImpl(context2.scope, context2.scope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(context2.trace), scopeDebugName);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        WritableScopeImpl writableScopeImpl = scope;
        if (writableScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        return writableScopeImpl;
    }

    public static boolean isBoolean(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isBoolean"));
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(type, KotlinBuiltIns.getInstance().getBooleanType());
    }

    public static boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context2) {
        return ExpressionTypingUtils.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context2);
    }

    public static boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context2) {
        if (resultType != null && !ExpressionTypingUtils.isBoolean(resultType)) {
            context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, KotlinBuiltIns.getInstance().getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    @NotNull
    public static JetType getDefaultType(IElementType constantType) {
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getIntType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getDoubleType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getBooleanType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getCharType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.NULL) {
            JetType jetType = KotlinBuiltIns.getInstance().getNullableNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    private static boolean isCapturedInInline(@NotNull BindingContext context2, @NotNull DeclarationDescriptor scopeContainer, @NotNull DeclarationDescriptor variableParent) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        if (scopeContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeContainer", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        if (variableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableParent", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!(scopeDeclaration instanceof JetFunctionLiteral)) {
            return false;
        }
        PsiElement parent = scopeDeclaration.getParent();
        assert (parent instanceof JetFunctionLiteralExpression) : "parent of JetFunctionLiteral is " + parent;
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getParentResolvedCall((JetFunctionLiteralExpression)parent, context2, true);
        if (resolvedCall == null) {
            return false;
        }
        CallableDescriptor callable2 = resolvedCall.getResultingDescriptor();
        if (callable2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)callable2).getInlineStrategy().isInline()) {
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            assert (scopeContainerParent != null) : "parent is null for " + scopeContainer;
            return scopeContainerParent == variableParent || ExpressionTypingUtils.isCapturedInInline(context2, scopeContainerParent, variableParent);
        }
        return false;
    }

    public static void checkCapturingInClosure(JetSimpleNameExpression expression, BindingTrace trace, JetScope scope) {
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable != null) {
            DeclarationDescriptor variableParent = variable.getContainingDeclaration();
            DeclarationDescriptor scopeContainer = scope.getContainingDeclaration();
            if (scopeContainer != variableParent && variableParent instanceof CallableDescriptor && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable) != CaptureKind.NOT_INLINE) {
                boolean inline2 = ExpressionTypingUtils.isCapturedInInline(trace.getBindingContext(), scopeContainer, variableParent);
                trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline2 ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
            }
        }
    }

    public static boolean checkIsExtensionCallable(@NotNull ReceiverValue receiverArgument, @NotNull CallableDescriptor callableDescriptor, boolean isInfixCall, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        if (isInfixCall && (!(callableDescriptor instanceof SimpleFunctionDescriptor) || callableDescriptor.getValueParameters().size() != 1)) {
            return false;
        }
        List<JetType> types = SmartCastUtils.getSmartCastVariants(receiverArgument, bindingContext, dataFlowInfo);
        for (JetType type : types) {
            JetType notNullableType;
            if (ExpressionTypingUtils.checkReceiverResolution(receiverArgument, type, callableDescriptor)) {
                return true;
            }
            if (!type.isNullable() || !ExpressionTypingUtils.checkReceiverResolution(receiverArgument, notNullableType = TypeUtils.makeNotNullable(type), callableDescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverValue receiverArgument, @NotNull JetType receiverType, @NotNull CallableDescriptor callableDescriptor) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        if (receiverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getExtensionReceiverParameter();
        if (!receiverArgument.exists() && receiverParameter == null) {
            return true;
        }
        if (!receiverArgument.exists() || receiverParameter == null) {
            return false;
        }
        Set<Name> typeNamesInReceiver = ExpressionTypingUtils.collectUsedTypeNames(receiverParameter.getType());
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        LinkedHashMap<TypeParameterDescriptor, Variance> typeVariables = Maps.newLinkedHashMap();
        for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
            if (!typeNamesInReceiver.contains(typeParameterDescriptor.getName())) continue;
            typeVariables.put(typeParameterDescriptor, Variance.INVARIANT);
        }
        constraintSystem.registerTypeVariables(typeVariables);
        constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPosition.RECEIVER_POSITION);
        return constraintSystem.getStatus().isSuccessful() && ConstraintsUtil.checkBoundsAreSatisfied(constraintSystem, true);
    }

    private static Set<Name> collectUsedTypeNames(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "collectUsedTypeNames"));
        }
        HashSet<Name> typeNames = new HashSet<Name>();
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor != null) {
            typeNames.add(descriptor.getName());
        }
        for (TypeProjection argument : jetType.getArguments()) {
            typeNames.addAll(ExpressionTypingUtils.collectUsedTypeNames(argument.getType()));
        }
        return typeNames;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context2, @NotNull ReceiverValue receiver, @NotNull Name name, JetType ... argumentTypes) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        TemporaryBindingTrace traceWithFakeArgumentInfo = TemporaryBindingTrace.create(context2.trace, "trace to store fake argument for", name);
        ArrayList<JetExpression> fakeArguments = Lists.newArrayList();
        for (JetType type : argumentTypes) {
            fakeArguments.add(ExpressionTypingUtils.createFakeExpressionOfType(this.expressionTypingServices.getProject(), traceWithFakeArgumentInfo, "fakeArgument" + fakeArguments.size(), type));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.makeAndResolveFakeCall(receiver, (ExpressionTypingContext)context2.replaceBindingTrace(traceWithFakeArgumentInfo), fakeArguments, name).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    public static JetExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull JetType argumentType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        JetExpression fakeExpression = PsiPackage.JetPsiFactory(project).createExpression(argumentName);
        trace.record(BindingContext.EXPRESSION_TYPE, fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context2, @NotNull ReceiverValue receiver, @NotNull Name name) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFakeCall(receiver, context2, Collections.<JetExpression>emptyList(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull List<JetExpression> valueArguments2, @NotNull Name name) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.makeAndResolveFakeCall(receiver, context2, valueArguments2, name).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public Pair<Call, OverloadResolutionResults<FunctionDescriptor>> makeAndResolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull List<JetExpression> valueArguments2, @NotNull Name name) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        final JetSimpleNameExpression fake = PsiPackage.JetPsiFactory(this.expressionTypingServices.getProject()).createSimpleName("fake");
        TemporaryBindingTrace fakeTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve fake call for", name);
        Call call = CallMaker.makeCallWithExpressions(fake, receiver, null, fake, valueArguments2);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCallWithGivenName((ExpressionTypingContext)context2.replaceBindingTrace(fakeTrace), call, fake, name);
        if (results.isSuccess()) {
            fakeTrace.commit(new TraceEntryFilter(){

                @Override
                public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                    return key != fake;
                }
            }, true);
        }
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> pair = Pair.create(call, results);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        return pair;
    }

    public void defineLocalVariablesFromMultiDeclaration(@NotNull WritableScope writableScope, @NotNull JetMultiDeclaration multiDeclaration, @NotNull ReceiverValue receiver, @NotNull JetExpression reportErrorsOn, @NotNull ExpressionTypingContext context2) {
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        int componentIndex = 1;
        for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
            Name componentName = DataClassUtilsPackage.createComponentName(componentIndex);
            ++componentIndex;
            JetType expectedType = this.getExpectedTypeForComponent(context2, entry);
            OverloadResolutionResults<FunctionDescriptor> results = this.resolveFakeCall((ExpressionTypingContext)context2.replaceExpectedType(expectedType), receiver, componentName);
            JetType componentType = null;
            if (results.isSuccess()) {
                context2.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                componentType = results.getResultingDescriptor().getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.DEFAULT.isSubtypeOf(componentType, expectedType)) {
                    context2.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on(reportErrorsOn, componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context2.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on(reportErrorsOn, componentName, results.getResultingCalls()));
            } else {
                context2.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on(reportErrorsOn, componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            VariableDescriptorImpl variableDescriptor = this.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context2.trace);
            VariableDescriptor olderVariable = writableScope.getLocalVariable(variableDescriptor.getName());
            ExpressionTypingUtils.checkVariableShadowing(context2, variableDescriptor, olderVariable);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    public static void checkVariableShadowing(@NotNull ExpressionTypingContext context2, @NotNull VariableDescriptor variableDescriptor, VariableDescriptor oldDescriptor) {
        PsiElement declaration;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (oldDescriptor != null && ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor)) != null) {
            context2.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    @NotNull
    private JetType getExpectedTypeForComponent(ExpressionTypingContext context2, JetMultiDeclarationEntry entry) {
        JetTypeReference entryTypeRef = entry.getTypeReference();
        if (entryTypeRef != null) {
            JetType jetType = this.expressionTypingServices.getTypeResolver().resolveType(context2.scope, entryTypeRef, context2.trace, true);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
            }
            return jetType;
        }
        JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
        }
        return jetType;
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull JetElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (expressionToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToWatch", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (mismatchFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchFound", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils$2", "report"));
                }
                DiagnosticFactory<?> factory2 = diagnostic.getFactory();
                if ((factory2 == Errors.TYPE_MISMATCH || factory2 == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH || factory2 == Errors.NULL_FOR_NONNULL_TYPE) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory2) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static JetTypeInfo getTypeInfoOrNullType(@Nullable JetExpression expression, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        JetTypeInfo jetTypeInfo = expression != null ? facade.getTypeInfo(expression, context2) : JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        return jetTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isBinaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return operationType == JetTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == JetTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isUnaryExpressionDependentOnExpectedType"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL;
    }

    @NotNull
    public static List<JetType> getValueParametersTypes(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        ArrayList<JetType> parameterTypes = new ArrayList<JetType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        ArrayList<JetType> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        return arrayList;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent = candidate.getContainingDeclaration();
        if (!(parent instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnExpectedType(@Nullable JetExpression expression) {
        JetExpression expr = JetPsiUtil.deparenthesize(expression, false);
        if (expr == null) {
            return false;
        }
        if (expr instanceof JetBinaryExpressionWithTypeRHS) {
            return false;
        }
        if (expr instanceof JetBinaryExpression) {
            return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType((JetBinaryExpression)expr);
        }
        if (expr instanceof JetUnaryExpression) {
            return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType((JetUnaryExpression)expr);
        }
        return true;
    }
}

