/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralArgument;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionResultsHandler;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.DelegatingCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lexer.JetTokens;

public class CallResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private CandidateResolver candidateResolver;
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private CallCompleter callCompleter;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setCandidateResolver(@NotNull CandidateResolver candidateResolver) {
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setCandidateResolver"));
        }
        this.candidateResolver = candidateResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCompleter", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.callCompleter = callCompleter;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context2) {
        CallableDescriptorCollectors<VariableDescriptor> callableDescriptorCollectors;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        JetExpression calleeExpression = context2.call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = Name.identifier(referencedName.asString().substring(1));
            callableDescriptorCollectors = CallableDescriptorCollectors.PROPERTIES;
        } else {
            callableDescriptorCollectors = CallableDescriptorCollectors.VARIABLES;
        }
        TracingStrategy tracing = TracingStrategyImpl.create(nameExpression, context2.call);
        List prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context2, referencedName, tracing, callableDescriptorCollectors);
        OverloadResolutionResultsImpl<VariableDescriptor> overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(context2, prioritizedTasks, CallTransformer.PROPERTY_CALL_TRANSFORMER, tracing);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ExpressionTypingContext context2, @NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.ENABLED), functionReference, name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicCallResolutionContext context2, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        TracingStrategy tracing = TracingStrategyImpl.create(functionReference, context2.call);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context2, name, tracing, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context2, Name.identifier("invoke"), tracing, CallableDescriptorCollectors.FUNCTIONS);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicCallResolutionContext context2, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull CallableDescriptorCollectors<CallableDescriptor> collectors) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        List tasks = TaskPrioritizer.computePrioritizedTasks(context2, name, tracing, collectors);
        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(context2, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context2, ExpressionReceiver receiver, JetBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context2, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveBinaryCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope, call, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckValueArgumentsMode.ENABLED, this.expressionTypingServices.createExtension(scope, isAnnotationContext), isAnnotationContext));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context2) {
        void var4_7;
        List prioritizedTasks;
        JetExpression calleeExpression;
        block27: {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            ProgressIndicatorProvider.checkCanceled();
            calleeExpression = context2.call.getCalleeExpression();
            if (calleeExpression instanceof JetSimpleNameExpression) {
                JetSimpleNameExpression expression;
                JetSimpleNameExpression jetSimpleNameExpression = expression = (JetSimpleNameExpression)calleeExpression;
                Name name = expression.getReferencedNameAsName();
                TracingStrategy tracing = TracingStrategyImpl.create(expression, context2.call);
                prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context2, name, tracing, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
                ResolutionTask.DescriptorCheckStrategy abstractConstructorCheck = new ResolutionTask.DescriptorCheckStrategy(){

                    @Override
                    public <D extends CallableDescriptor> boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
                        Modality modality;
                        if (descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
                            tracing.instantiationOfAbstractClass(trace);
                            return false;
                        }
                        return true;
                    }
                };
                for (ResolutionTask resolutionTask : prioritizedTasks) {
                    resolutionTask.setCheckingStrategy(abstractConstructorCheck);
                }
            } else {
                JetValueArgumentList reportAbsenceOn;
                JetValueArgumentList valueArgumentList = context2.call.getValueArgumentList();
                JetElement jetElement = reportAbsenceOn = valueArgumentList == null ? context2.call.getCallElement() : valueArgumentList;
                if (calleeExpression instanceof JetConstructorCalleeExpression) {
                    assert (!context2.call.getExplicitReceiver().exists());
                    JetConstructorCalleeExpression expression = (JetConstructorCalleeExpression)calleeExpression;
                    JetReferenceExpression jetReferenceExpression = expression.getConstructorReferenceExpression();
                    if (jetReferenceExpression == null) {
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    JetTypeReference typeReference = expression.getTypeReference();
                    assert (typeReference != null);
                    JetType constructedType = this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
                    if (constructedType.isError()) {
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    ClassifierDescriptor classifierDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor instanceof ClassDescriptor) {
                        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                        Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
                        if (constructors.isEmpty()) {
                            context2.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                            if (overloadResolutionResultsImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                            }
                            return overloadResolutionResultsImpl;
                        }
                        Collection candidates = TaskPrioritizer.convertWithImpliedThisAndNoReceiver(context2.scope, constructors, context2.call);
                        prioritizedTasks = TaskPrioritizer.computePrioritizedTasksFromCandidates(context2, candidates, TracingStrategyImpl.create(jetReferenceExpression, context2.call));
                        break block27;
                    } else {
                        context2.trace.report(Errors.NOT_A_CLASS.on(calleeExpression));
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                }
                if (calleeExpression instanceof JetThisReferenceExpression) {
                    JetThisReferenceExpression jetThisReferenceExpression = (JetThisReferenceExpression)calleeExpression;
                    DeclarationDescriptor containingDeclaration = context2.scope.getContainingDeclaration();
                    if (containingDeclaration instanceof ConstructorDescriptor) {
                        containingDeclaration = containingDeclaration.getContainingDeclaration();
                    }
                    assert (containingDeclaration instanceof ClassDescriptor);
                    ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                    Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
                    if (constructors.isEmpty()) {
                        context2.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    List list = ResolutionCandidate.convertCollection(context2.call, constructors, JetPsiUtil.isSafeCall(context2.call));
                    prioritizedTasks = Collections.singletonList(new ResolutionTask(list, jetThisReferenceExpression, context2));
                } else {
                    if (calleeExpression != null) {
                        JetType calleeType = this.expressionTypingServices.safeGetType(context2.scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE, context2.dataFlowInfo, context2.trace);
                        ExpressionReceiver expressionReceiver = new ExpressionReceiver(calleeExpression, calleeType);
                        CallTransformer.CallForImplicitInvoke call = new CallTransformer.CallForImplicitInvoke(context2.call.getExplicitReceiver(), expressionReceiver, context2.call);
                        TracingStrategyForInvoke tracingStrategyForInvoke = new TracingStrategyForInvoke(calleeExpression, call, calleeType);
                        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForInvoke(context2.replaceCall(call), tracingStrategyForInvoke);
                        if (overloadResolutionResults == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResults;
                    }
                    OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
                    if (overloadResolutionResultsImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                    }
                    return overloadResolutionResultsImpl;
                }
            }
        }
        TracingStrategy tracing = TracingStrategyImpl.create((JetReferenceExpression)var4_7, context2.call);
        OverloadResolutionResultsImpl<FunctionDescriptor> results = this.doResolveCallOrGetCachedResults(context2, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
        if (calleeExpression instanceof JetSimpleNameExpression) {
            ExpressionTypingUtils.checkCapturingInClosure((JetSimpleNameExpression)calleeExpression, context2.trace, context2.scope);
        }
        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResultsImpl;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context2, @NotNull ResolutionCandidate<CallableDescriptor> candidate, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.ENABLED, dataFlowInfoForArguments);
        List tasks = TaskPrioritizer.computePrioritizedTasksFromCandidates(basicCallResolutionContext, Collections.singleton(candidate), tracing);
        return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context2, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        ResolutionResultsCache.CachedData data2;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        Call call = context2.call;
        tracing.bindCall(context2.trace, call);
        OverloadResolutionResultsImpl<Object> results = null;
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context2.trace, "trace to resolve call", call);
        if (!CallResolverUtil.isInvokeCallOnVariable(call) && (data2 = context2.resolutionResultsCache.get(call)) != null) {
            DelegatingBindingTrace deltasTraceForResolve = data2.getResolutionTrace();
            deltasTraceForResolve.addAllMyDataTo(traceToResolveCall);
            results = data2.getResolutionResults();
        }
        if (results == null) {
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)context2.replaceBindingTrace(traceToResolveCall);
            BindingContextUtilPackage.recordScopeAndDataFlowInfo(newContext, newContext.call.getCalleeExpression());
            results = this.doResolveCall(newContext, prioritizedTasks, callTransformer, tracing);
            DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
            if (deltasTraceForTypeInference != null) {
                deltasTraceForTypeInference.addAllMyDataTo(traceToResolveCall);
            }
            this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
            CallResolver.cacheResults(context2, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context2, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (CallResolverUtil.isInvokeCallOnVariable(context2.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context2, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnFunctionLiteralsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (traceToResolveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceToResolveCall", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        Call call = context2.call;
        if (CallResolverUtil.isInvokeCallOnVariable(call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context2.call);
        traceToResolveCall.addAllMyDataTo(deltasTraceToCacheResolve);
        context2.resolutionResultsCache.record(call, results, context2, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context2) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context2);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        OverloadResolutionResultsImpl results;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.ENABLED) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context2);
        }
        ArrayList allCandidates = Lists.newArrayList();
        OverloadResolutionResultsImpl<Object> successfulResults = null;
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            boolean updateResults;
            if (successfulResults != null && !context2.collectAllCandidates) continue;
            TemporaryBindingTrace taskTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve a task for", task.call.getCalleeExpression());
            OverloadResolutionResultsImpl<F> results2 = this.performResolutionGuardedForExtraFunctionLiteralArguments((ResolutionTask)task.replaceBindingTrace(taskTrace), callTransformer);
            allCandidates.addAll(task.getResolvedCalls());
            if (successfulResults != null) continue;
            if (results2.isSuccess() || results2.isAmbiguity()) {
                taskTrace.commit();
                successfulResults = results2;
            }
            if (results2.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                results2.setTrace(taskTrace);
                successfulResults = results2;
            }
            boolean bl = updateResults = traceForFirstNonemptyCandidateSet == null || resultsForFirstNonemptyCandidateSet.getResultCode() == OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER && results2.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            if (task.getCandidates().isEmpty() || results2.isNothing() || !updateResults) continue;
            traceForFirstNonemptyCandidateSet = taskTrace;
            resultsForFirstNonemptyCandidateSet = results2;
        }
        if (successfulResults != null) {
            results = successfulResults;
        } else if (traceForFirstNonemptyCandidateSet == null) {
            tracing.unresolvedReference(context2.trace);
            this.argumentTypeResolver.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            results = OverloadResolutionResultsImpl.nameNotFound();
        } else {
            traceForFirstNonemptyCandidateSet.commit();
            results = resultsForFirstNonemptyCandidateSet;
        }
        results.setAllCandidates(context2.collectAllCandidates ? allCandidates : null);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolutionGuardedForExtraFunctionLiteralArguments(final @NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        OverloadResolutionResultsImpl<F> results = this.performResolution(task, callTransformer);
        ImmutableSet<OverloadResolutionResults.Code> someFailed = ImmutableSet.of(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH);
        if (someFailed.contains((Object)results.getResultCode()) && !task.call.getFunctionLiteralArguments().isEmpty() && task.contextDependency == ContextDependency.INDEPENDENT) {
            DelegatingCall callWithoutFLArgs = new DelegatingCall(task.call){

                @Override
                @NotNull
                public List<? extends ValueArgument> getValueArguments() {
                    List<ValueArgument> list = CallUtilPackage.getValueArgumentsInParentheses(task.call);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver$2", "getValueArguments"));
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
                    List<JetFunctionLiteralArgument> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver$2", "getFunctionLiteralArguments"));
                    }
                    return list;
                }
            };
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(task.trace, "trace for resolution guarded for extra function literal arguments");
            ResolutionTask newTask = ((ResolutionTask)new ResolutionTask(task.getCandidates(), task.toBasic(), task.tracing).replaceBindingTrace(temporaryTrace)).replaceCall(callWithoutFLArgs);
            OverloadResolutionResultsImpl resultsWithFunctionLiteralsStripped = this.performResolution(newTask, callTransformer);
            if (resultsWithFunctionLiteralsStripped.isSuccess() || resultsWithFunctionLiteralsStripped.isAmbiguity()) {
                task.tracing.danglingFunctionLiteralArgumentSuspected(task.trace, task.call.getFunctionLiteralArguments());
            }
        }
        OverloadResolutionResultsImpl<F> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        for (ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace, "trace to resolve candidate");
            Collection<CallCandidateResolutionContext<D>> contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace);
            for (CallCandidateResolutionContext<D> context2 : contexts) {
                this.candidateResolver.performResolutionForCandidateCall(context2, task);
                task.tracing.bindReference(context2.candidateCall.getTrace(), context2.candidateCall);
                Collection<MutableResolvedCall<F>> resolvedCalls = callTransformer.transformCall(context2, this, task);
                for (MutableResolvedCall<F> resolvedCall : resolvedCalls) {
                    DelegatingBindingTrace trace = resolvedCall.getTrace();
                    task.tracing.bindReference(trace, resolvedCall);
                    task.tracing.bindResolvedCall(trace, resolvedCall);
                    task.addResolvedCall(resolvedCall);
                }
            }
        }
        OverloadResolutionResultsImpl results = ResolutionResultsHandler.INSTANCE.computeResultAndReportErrors(task, task.getResolvedCalls());
        if (!results.isSingleResult() && !results.isIncomplete()) {
            this.argumentTypeResolver.checkTypesWithNoCallee(task.toBasic());
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        return overloadResolutionResultsImpl;
    }
}

