/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.FilteringScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public interface Importer {
    public static final Importer DO_NOTHING = new Importer(){

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$1", "addAllUnderImport"));
            }
            if (platformToKotlinClassMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/resolve/Importer$1", "addAllUnderImport"));
            }
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$1", "addAliasImport"));
            }
            if (aliasName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/Importer$1", "addAliasImport"));
            }
        }
    };

    public void addAllUnderImport(@NotNull DeclarationDescriptor var1, @NotNull PlatformToKotlinClassMap var2);

    public void addAliasImport(@NotNull DeclarationDescriptor var1, @NotNull Name var2);

    public static class DelayedImporter
    extends StandardImporter {
        private final List<DelayedImportEntry> imports;

        public DelayedImporter(@NotNull WritableScope fileScope) {
            if (fileScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScope", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter", "<init>"));
            }
            super(fileScope);
            this.imports = Lists.newArrayList();
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter", "addAllUnderImport"));
            }
            if (platformToKotlinClassMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter", "addAllUnderImport"));
            }
            this.imports.add(new AllUnderImportEntry(descriptor, platformToKotlinClassMap));
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter", "addAliasImport"));
            }
            if (aliasName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter", "addAliasImport"));
            }
            this.imports.add(new AliasImportEntry(descriptor, aliasName));
        }

        public void processImports() {
            for (DelayedImportEntry anImport : this.imports) {
                if (anImport instanceof AllUnderImportEntry) {
                    AllUnderImportEntry allUnderImportEntry = (AllUnderImportEntry)anImport;
                    this.importAllUnderDeclaration((DeclarationDescriptor)allUnderImportEntry.getFirst(), (PlatformToKotlinClassMap)allUnderImportEntry.getSecond());
                    continue;
                }
                AliasImportEntry aliasImportEntry = (AliasImportEntry)anImport;
                this.importDeclarationAlias((DeclarationDescriptor)aliasImportEntry.getFirst(), (Name)aliasImportEntry.getSecond());
            }
        }

        private static class AliasImportEntry
        extends Pair<DeclarationDescriptor, Name>
        implements DelayedImportEntry {
            public AliasImportEntry(DeclarationDescriptor first, Name second) {
                super(first, second);
            }
        }

        private static class AllUnderImportEntry
        extends Pair<DeclarationDescriptor, PlatformToKotlinClassMap>
        implements DelayedImportEntry {
            public AllUnderImportEntry(@NotNull DeclarationDescriptor first, @Nullable PlatformToKotlinClassMap second) {
                if (first == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/lang/resolve/Importer$DelayedImporter$AllUnderImportEntry", "<init>"));
                }
                super(first, second);
            }
        }

        private static interface DelayedImportEntry {
        }
    }

    public static class StandardImporter
    implements Importer {
        private final WritableScope fileScope;

        public StandardImporter(WritableScope fileScope) {
            this.fileScope = fileScope;
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "addAllUnderImport"));
            }
            if (platformToKotlinClassMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "addAllUnderImport"));
            }
            this.importAllUnderDeclaration(descriptor, platformToKotlinClassMap);
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "addAliasImport"));
            }
            if (aliasName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "addAliasImport"));
            }
            this.importDeclarationAlias(descriptor, aliasName);
        }

        @NotNull
        private static JetScope createFilteringScope(@NotNull JetScope scope, @NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "createFilteringScope"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "createFilteringScope"));
            }
            if (platformToKotlinClassMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "createFilteringScope"));
            }
            final Collection<ClassDescriptor> kotlinAnalogsForClassesInside = platformToKotlinClassMap.mapPlatformClassesInside(descriptor);
            if (kotlinAnalogsForClassesInside.isEmpty()) {
                JetScope jetScope = scope;
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "createFilteringScope"));
                }
                return jetScope;
            }
            FilteringScope filteringScope = new FilteringScope(scope, new Function1<DeclarationDescriptor, Boolean>(){

                @Override
                public Boolean invoke(DeclarationDescriptor descriptor) {
                    for (ClassDescriptor kotlinAnalog : kotlinAnalogsForClassesInside) {
                        if (!kotlinAnalog.getName().equals(descriptor.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
            if (filteringScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "createFilteringScope"));
            }
            return filteringScope;
        }

        protected void importAllUnderDeclaration(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "importAllUnderDeclaration"));
            }
            if (platformToKotlinClassMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "importAllUnderDeclaration"));
            }
            ArrayList<JetScope> scopesToImport = new ArrayList<JetScope>(3);
            if (descriptor instanceof PackageViewDescriptor) {
                scopesToImport.add(((PackageViewDescriptor)descriptor).getMemberScope());
            } else if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.OBJECT) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
                scopesToImport.add(classDescriptor.getStaticScope());
                scopesToImport.add(classDescriptor.getUnsubstitutedInnerClassesScope());
                ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
                if (classObjectDescriptor != null) {
                    scopesToImport.add(classObjectDescriptor.getUnsubstitutedInnerClassesScope());
                }
            }
            for (JetScope scope : scopesToImport) {
                this.fileScope.importScope(StandardImporter.createFilteringScope(scope, descriptor, platformToKotlinClassMap));
            }
        }

        protected void importDeclarationAlias(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "importDeclarationAlias"));
            }
            if (aliasName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/Importer$StandardImporter", "importDeclarationAlias"));
            }
            if (descriptor instanceof ClassifierDescriptor) {
                this.fileScope.importClassifierAlias(aliasName, (ClassifierDescriptor)descriptor);
            } else if (descriptor instanceof PackageViewDescriptor) {
                this.fileScope.importPackageAlias(aliasName, (PackageViewDescriptor)descriptor);
            } else if (descriptor instanceof FunctionDescriptor) {
                this.fileScope.importFunctionAlias(aliasName, (FunctionDescriptor)descriptor);
            } else if (descriptor instanceof VariableDescriptor) {
                this.fileScope.importVariableAlias(aliasName, (VariableDescriptor)descriptor);
            }
        }
    }
}

