/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.AdditionalCheckerProvider;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class DeclarationsChecker {
    @NotNull
    private BindingTrace trace;
    @NotNull
    private ModifiersChecker modifiersChecker;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private AdditionalCheckerProvider additionalCheckerProvider;

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "setTrace"));
        }
        this.trace = trace;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setAdditionalCheckerProvider(@NotNull AdditionalCheckerProvider additionalCheckerProvider) {
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "setAdditionalCheckerProvider"));
        }
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    @Inject
    public void setModifiersChecker(@NotNull ModifiersChecker modifiersChecker) {
        if (modifiersChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersChecker", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "setModifiersChecker"));
        }
        this.modifiersChecker = modifiersChecker;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "process"));
        }
        for (JetFile file : bodiesResolveContext.getFiles()) {
            this.checkModifiersAndAnnotationsInPackageDirective(file);
        }
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> classes2 = bodiesResolveContext.getDeclaredClasses();
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : classes2.entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(classOrObject)) continue;
            this.checkSupertypesForConsistency(classDescriptor);
            this.checkTypesInClassHeader(classOrObject);
            if (classOrObject instanceof JetClass) {
                JetClass jetClass = (JetClass)classOrObject;
                this.checkClass(bodiesResolveContext, jetClass, classDescriptor);
                this.descriptorResolver.checkNamesInConstraints(jetClass, classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if (classOrObject instanceof JetObjectDeclaration) {
                this.checkObject((JetObjectDeclaration)classOrObject, classDescriptor);
            }
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptor);
        }
        Map<JetNamedFunction, SimpleFunctionDescriptor> functions2 = bodiesResolveContext.getFunctions();
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : functions2.entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(function)) continue;
            this.checkFunction(function, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(function, functionDescriptor);
        }
        Map<JetProperty, PropertyDescriptor> properties2 = bodiesResolveContext.getProperties();
        for (Map.Entry<JetProperty, PropertyDescriptor> entry : properties2.entrySet()) {
            JetProperty property2 = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(property2)) continue;
            this.checkProperty(property2, propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(property2, propertyDescriptor);
        }
    }

    private void reportErrorIfHasIllegalModifier(JetModifierListOwner declaration) {
        if (declaration.hasModifier(JetTokens.ENUM_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ENUM_ANNOTATION.on(declaration));
        }
        if (declaration.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ANNOTATION_KEYWORD.on(declaration));
        }
    }

    private void checkModifiersAndAnnotationsInPackageDirective(JetFile file) {
        JetPackageDirective packageDirective = file.getPackageDirective();
        if (packageDirective == null) {
            return;
        }
        JetModifierList modifierList = packageDirective.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            JetReferenceExpression reference;
            JetConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        ModifiersChecker.reportIllegalModifiers(modifierList, Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY), this.trace);
    }

    private void checkTypesInClassHeader(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkTypesInClassHeader"));
        }
        for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
            this.checkBoundsForTypeInClassHeader(delegationSpecifier.getTypeReference());
        }
        if (!(classOrObject instanceof JetClass)) {
            return;
        }
        JetClass jetClass = (JetClass)classOrObject;
        for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
            this.checkBoundsForTypeInClassHeader(jetTypeParameter.getExtendsBound());
            this.checkFinalUpperBounds(jetTypeParameter.getExtendsBound(), false);
        }
        for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
            this.checkBoundsForTypeInClassHeader(constraint.getBoundTypeReference());
            this.checkFinalUpperBounds(constraint.getBoundTypeReference(), constraint.isClassObjectConstraint());
        }
    }

    private void checkBoundsForTypeInClassHeader(@Nullable JetTypeReference typeReference) {
        JetType type;
        if (typeReference != null && (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkBounds(typeReference, type, this.trace);
        }
    }

    private void checkFinalUpperBounds(@Nullable JetTypeReference typeReference, boolean isClassObjectConstraint) {
        JetType type;
        if (typeReference != null && (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkUpperBoundType(typeReference, type, isClassObjectConstraint, this.trace);
        }
    }

    private void checkSupertypesForConsistency(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkSupertypesForConsistency"));
        }
        Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classDescriptor.getDefaultType());
        for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            TypeConstructor typeConstructor = entry.getKey();
            ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
            assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
            for (TypeProjection projection : projections) {
                conflictingTypes.add(projection.getType());
            }
            switch (typeParameterDescriptor.getVariance()) {
                case INVARIANT: {
                    break;
                }
                case IN_VARIANCE: {
                    Filter.REMOVE_IF_SUPERTYPE_IN_THE_SET.proceed(conflictingTypes);
                    break;
                }
                case OUT_VARIANCE: {
                    Filter.REMOVE_IF_SUBTYPE_IN_THE_SET.proceed(conflictingTypes);
                }
            }
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
            JetClassOrObject psiElement = (JetClassOrObject)DescriptorToSourceUtils.classDescriptorToDeclaration(classDescriptor);
            JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
            assert (delegationSpecifierList != null);
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
        }
    }

    private void checkObject(JetObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        this.reportErrorIfHasIllegalModifier(declaration);
        if (declaration.isLocal() && !declaration.isClassObject() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on(declaration, classDescriptor));
        }
    }

    private void checkClass(BodiesResolveContext c, JetClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (c.getTopDownAnalysisParameters().isLazyTopDownAnalysis()) {
            this.checkTypeParameters(aClass);
        }
        if (aClass.isTrait()) {
            this.checkTraitModifiers(aClass);
            this.checkConstructorInTrait(aClass);
        } else if (aClass.isAnnotation()) {
            this.checkAnnotationClassWithBody(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass.isEnum()) {
            this.checkEnumModifiers(aClass);
            if (aClass.isLocal()) {
                this.trace.report(Errors.LOCAL_ENUM_NOT_ALLOWED.on(aClass, classDescriptor));
            }
        } else if (aClass instanceof JetEnumEntry) {
            this.checkEnumEntry((JetEnumEntry)aClass, classDescriptor);
        }
    }

    private void checkTypeParameters(JetTypeParameterListOwner typeParameterListOwner) {
        for (JetTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            TypeParameterDescriptor typeParameter = this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter);
            if (typeParameter == null) continue;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, typeParameter, jetTypeParameter);
        }
    }

    private void checkConstructorInTrait(JetClass klass) {
        JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
        if (primaryConstructorParameterList != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructorParameterList));
        }
    }

    private void checkTraitModifiers(JetClass aClass) {
        this.reportErrorIfHasIllegalModifier(aClass);
        JetModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.hasModifier(JetTokens.FINAL_KEYWORD)) {
            this.trace.report(Errors.TRAIT_CAN_NOT_BE_FINAL.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_TRAIT.on(aClass));
        }
    }

    private void checkAnnotationClassWithBody(JetClassOrObject classOrObject) {
        if (classOrObject.getBody() != null) {
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(classOrObject.getBody()));
        }
    }

    private void checkValOnAnnotationParameter(JetClass aClass) {
        for (JetParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVarNode()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on(parameter));
        }
    }

    private void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            JetNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || (member = (JetNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor)) == null || !member.hasModifier(JetTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(JetProperty property2, PropertyDescriptor propertyDescriptor) {
        this.reportErrorIfHasIllegalModifier(property2);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkPropertyAbstractness(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        } else {
            this.modifiersChecker.checkIllegalModalityModifiers(property2);
        }
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkDeclaredTypeInPublicMember(property2, propertyDescriptor);
    }

    private void checkDeclaredTypeInPublicMember(JetNamedDeclaration member, CallableMemberDescriptor memberDescriptor) {
        boolean hasDeferredType;
        if (member instanceof JetProperty) {
            hasDeferredType = ((JetProperty)member).getTypeReference() == null && DescriptorResolver.hasBody((JetProperty)member);
        } else {
            assert (member instanceof JetFunction);
            JetFunction function = (JetFunction)member;
            boolean bl = hasDeferredType = function.getTypeReference() == null && function.hasBody() && !function.hasBlockBody();
        }
        if (memberDescriptor.getVisibility().isPublicAPI() && memberDescriptor.getOverriddenDescriptors().size() == 0 && hasDeferredType) {
            this.trace.report(Errors.PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE.on(member));
        }
    }

    private void checkPropertyAbstractness(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull ClassDescriptor classDescriptor) {
        ASTNode abstractNode;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        JetPropertyAccessor setter = property2.getSetter();
        JetModifierList modifierList = property2.getModifierList();
        ASTNode aSTNode = abstractNode = modifierList != null ? modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD) : null;
        if (abstractNode != null) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                String name = property2.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property2, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.TRAIT) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(property2));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            JetPropertyDelegate delegate2;
            JetExpression initializer;
            JetType returnType = propertyDescriptor.getReturnType();
            if (returnType instanceof DeferredType) {
                returnType = ((DeferredType)returnType).getDelegate();
            }
            if ((initializer = property2.getInitializer()) != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer));
            }
            if ((delegate2 = property2.getDelegate()) != null) {
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on(delegate2));
            }
            if (getter != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter));
            }
            if (setter != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter));
            }
        }
    }

    private void checkPropertyInitializer(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean hasAccessorImplementation;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        JetPropertyAccessor setter = property2.getSetter();
        boolean bl = hasAccessorImplementation = getter != null && getter.hasBody() || setter != null && setter.hasBody();
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            return;
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean inTrait = containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.TRAIT;
        JetExpression initializer = property2.getInitializer();
        JetPropertyDelegate delegate2 = property2.getDelegate();
        boolean backingFieldRequired = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_TRAIT.on(property2));
        }
        if (initializer == null && delegate2 == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && Boolean.FALSE.equals(this.trace.getBindingContext().get(BindingContext.IS_INITIALIZED, propertyDescriptor))) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property2));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property2));
                }
            }
            if (!error && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            if (inTrait && property2.hasModifier(JetTokens.FINAL_KEYWORD) && backingFieldRequired) {
                this.trace.report(Errors.FINAL_PROPERTY_IN_TRAIT.on(property2));
            }
            return;
        }
        if (inTrait) {
            if (delegate2 != null) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_TRAIT.on(delegate2));
            } else {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_TRAIT.on(initializer));
            }
        } else if (delegate2 == null) {
            if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer));
            } else if (property2.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on(initializer));
            }
        }
    }

    protected void checkFunction(JetNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        this.reportErrorIfHasIllegalModifier(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        this.checkDeclaredTypeInPublicMember(function, functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean bl = inTrait = classDescriptor.getKind() == ClassKind.TRAIT;
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().asString(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(function));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (!hasBody && function.hasModifier(JetTokens.FINAL_KEYWORD) && inTrait) {
                this.trace.report(Errors.FINAL_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        this.modifiersChecker.checkIllegalModalityModifiers(function);
        if (!function.hasBody() && !hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
    }

    private void checkAccessors(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        block7: {
            JetModifierList getterModifierList;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkAccessors"));
            }
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkAccessors"));
            }
            for (JetPropertyAccessor accessor : property2.getAccessors()) {
                this.modifiersChecker.checkIllegalModalityModifiers(accessor);
            }
            JetPropertyAccessor getter = property2.getGetter();
            PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
            JetModifierList jetModifierList = getterModifierList = getter != null ? getter.getModifierList() : null;
            if (getterModifierList == null || getterDescriptor == null) break block7;
            Map<JetModifierKeywordToken, ASTNode> nodes = ModifiersChecker.getNodesCorrespondingToModifiers(getterModifierList, Sets.newHashSet(JetTokens.PUBLIC_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.INTERNAL_KEYWORD));
            if (getterDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY.on(node.getPsi()));
                }
            } else {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.REDUNDANT_MODIFIER_IN_GETTER.on(node.getPsi()));
                }
            }
        }
    }

    private void checkEnumModifiers(JetClass aClass) {
        if (aClass.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_ENUM.on(aClass));
        }
        if (aClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_ENUM.on(aClass));
        }
    }

    private void checkEnumEntry(@NotNull JetEnumEntry enumEntry, @NotNull ClassDescriptor classDescriptor) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(declaration)) : "Enum entry should be declared in enum class: " + classDescriptor;
        ClassDescriptor enumClass = (ClassDescriptor)declaration;
        List<JetDelegationSpecifier> delegationSpecifiers = enumEntry.getDelegationSpecifiers();
        ConstructorDescriptor constructor = enumClass.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null);
        if (!constructor.getValueParameters().isEmpty() && delegationSpecifiers.isEmpty()) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(enumEntry, enumClass));
        }
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetType type;
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
            JetType enumType = enumClass.getDefaultType();
            if (type.getConstructor().equals(enumType.getConstructor())) continue;
            this.trace.report(Errors.ENUM_ENTRY_ILLEGAL_TYPE.on(typeReference, enumClass));
        }
    }

    private static enum Filter {
        REMOVE_IF_SUBTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.DEFAULT.isSubtypeOf(other, subject);
            }
        }
        ,
        REMOVE_IF_SUPERTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.DEFAULT.isSubtypeOf(subject, other);
            }
        };


        private void proceed(Set<JetType> conflictingTypes) {
            Iterator<JetType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                JetType type = iterator2.next();
                for (JetType otherType : conflictingTypes) {
                    boolean subtypeOf = this.removeNeeded(type, otherType);
                    if (type == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        public abstract boolean removeNeeded(JetType var1, JetType var2);
    }
}

