/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.StorageManager;

public class AnnotationResolver {
    private CallResolver callResolver;
    private StorageManager storageManager;
    private TypeResolver typeResolver;

    @Inject
    public void setCallResolver(CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @Inject
    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @NotNull
    public Annotations resolveAnnotationsWithoutArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        Annotations annotations = this.resolveAnnotations(scope, modifierList, trace, false);
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        return annotations;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations = this.resolveAnnotations(scope, modifierList, trace, true);
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull JetScope scope, @NotNull List<JetAnnotationEntry> annotationEntries, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (annotationEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntries", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations = this.resolveAnnotationEntries(scope, annotationEntries, trace, true);
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations;
    }

    private Annotations resolveAnnotations(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (modifierList == null) {
            return Annotations.EMPTY;
        }
        List<JetAnnotationEntry> annotationEntryElements = modifierList.getAnnotationEntries();
        return this.resolveAnnotationEntries(scope, annotationEntryElements, trace, shouldResolveArguments);
    }

    private Annotations resolveAnnotationEntries(@NotNull JetScope scope, @NotNull List<JetAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntryElements", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements.isEmpty()) {
            return Annotations.EMPTY;
        }
        ArrayList<AnnotationDescriptor> result2 = Lists.newArrayList();
        for (JetAnnotationEntry entryElement : annotationEntryElements) {
            AnnotationDescriptor descriptor = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor == null) {
                descriptor = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope), entryElement);
            }
            if (shouldResolveArguments) {
                AnnotationResolver.resolveAnnotationArguments(entryElement, trace);
            }
            result2.add(descriptor);
        }
        return new AnnotationsImpl(result2);
    }

    @NotNull
    public JetType resolveAnnotationType(@NotNull JetScope scope, @NotNull JetAnnotationEntry entryElement) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        JetTypeReference typeReference = entryElement.getTypeReference();
        if (typeReference == null) {
            JetType jetType = ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationType"));
            }
            return jetType;
        }
        JetType jetType = this.typeResolver.resolveType(scope, typeReference, new BindingTraceContext(), true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        return jetType;
    }

    public static void checkAnnotationType(@NotNull JetAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor)) {
            if (descriptor instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor;
                ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
                if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor));
            }
        }
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(JetAnnotationEntry annotationEntry, JetScope scope, BindingTrace trace) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(trace, scope, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, true);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationCall"));
        }
        return overloadResolutionResults;
    }

    public static void resolveAnnotationsArguments(@Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            AnnotationResolver.resolveAnnotationArguments(annotationEntry, trace);
        }
    }

    public static void resolveAnnotationsArguments(@NotNull Annotations annotations, @NotNull BindingTrace trace) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        for (AnnotationDescriptor annotationDescriptor : annotations) {
            JetAnnotationEntry annotationEntry = trace.getBindingContext().get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotationDescriptor);
            assert (annotationEntry != null) : "Cannot find annotation entry: " + annotationDescriptor;
            AnnotationResolver.resolveAnnotationArguments(annotationEntry, trace);
        }
    }

    private static void resolveAnnotationArguments(@NotNull JetAnnotationEntry annotationEntry, @NotNull BindingTrace trace) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        AnnotationDescriptor annotationDescriptor = trace.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry);
        assert (annotationDescriptor != null) : "Annotation descriptor should be created before resolving arguments for " + annotationEntry.getText();
        if (annotationDescriptor instanceof LazyAnnotationDescriptor) {
            ((LazyAnnotationDescriptor)annotationDescriptor).forceResolveAllContents();
        }
    }

    @NotNull
    public static Map<ValueParameterDescriptor, CompileTimeConstant<?>> resolveAnnotationArguments(@NotNull ResolvedCall<?> resolvedCall, @NotNull BindingTrace trace) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        HashMap arguments = new HashMap();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> descriptorToArgument : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedArgument;
            ValueParameterDescriptor parameterDescriptor = descriptorToArgument.getKey();
            CompileTimeConstant<?> value = AnnotationResolver.getAnnotationArgumentValue(trace, parameterDescriptor, resolvedArgument = descriptorToArgument.getValue());
            if (value == null) continue;
            arguments.put(parameterDescriptor, value);
        }
        HashMap hashMap = arguments;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        return hashMap;
    }

    @Nullable
    public static CompileTimeConstant<?> getAnnotationArgumentValue(BindingTrace trace, ValueParameterDescriptor parameterDescriptor, ResolvedValueArgument resolvedArgument) {
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !AnnotationResolver.hasSpread(resolvedArgument);
        List<CompileTimeConstant<?>> constants = AnnotationResolver.resolveValueArguments(resolvedArgument, argumentsAsVararg ? varargElementType : parameterDescriptor.getType(), trace);
        if (argumentsAsVararg) {
            boolean usesVariableAsConstant = KotlinPackage.any(constants, new Function1<CompileTimeConstant<?>, Boolean>(){

                @Override
                public Boolean invoke(CompileTimeConstant<?> constant) {
                    return constant.usesVariableAsConstant();
                }
            });
            JetType arrayType = KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(varargElementType);
            if (arrayType == null) {
                arrayType = KotlinBuiltIns.getInstance().getArrayType(varargElementType);
            }
            return new ArrayValue(constants, arrayType, true, usesVariableAsConstant);
        }
        return !constants.isEmpty() ? KotlinPackage.last(constants) : null;
    }

    private static void checkCompileTimeConstant(@NotNull JetExpression argumentExpression, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        CompileTimeConstant<?> constant;
        Pair<List<JetExpression>, JetType> arrayArgument;
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        JetType expressionType = trace.get(BindingContext.EXPRESSION_TYPE, argumentExpression);
        if (expressionType == null || !((Object)expressionType).equals(expectedType)) {
            return;
        }
        if (argumentExpression instanceof JetCallExpression && (arrayArgument = AnnotationResolver.getArgumentExpressionsForArrayCall((JetCallExpression)argumentExpression, trace)) != null) {
            for (JetExpression expression : arrayArgument.getFirst()) {
                AnnotationResolver.checkCompileTimeConstant(expression, arrayArgument.getSecond(), trace);
            }
        }
        if ((constant = trace.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression)) != null && constant.canBeUsedInAnnotations()) {
            return;
        }
        ClassifierDescriptor descriptor = expressionType.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && DescriptorUtils.isEnumClass(descriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on(argumentExpression));
        } else if (descriptor instanceof ClassDescriptor && CompileTimeConstantUtils.isJavaLangClass((ClassDescriptor)descriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CLASS_LITERAL.on(argumentExpression));
        } else {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on(argumentExpression));
        }
    }

    @Nullable
    private static Pair<List<JetExpression>, JetType> getArgumentExpressionsForArrayCall(@NotNull JetCallExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getArgumentExpressionsForArrayCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getArgumentExpressionsForArrayCall"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, trace.getBindingContext());
        if (resolvedCall == null || !CompileTimeConstantUtils.isArrayMethodCall(resolvedCall)) {
            return null;
        }
        assert (resolvedCall.getValueArguments().size() == 1) : "Array function should have only one vararg parameter";
        Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> argumentEntry = resolvedCall.getValueArguments().entrySet().iterator().next();
        ArrayList<JetExpression> result2 = Lists.newArrayList();
        JetType elementType = argumentEntry.getKey().getVarargElementType();
        for (ValueArgument valueArgument : argumentEntry.getValue().getArguments()) {
            JetExpression valueArgumentExpression = valueArgument.getArgumentExpression();
            if (valueArgumentExpression == null || elementType == null) continue;
            result2.add(valueArgumentExpression);
        }
        return new Pair<List<JetExpression>, JetType>(result2, elementType);
    }

    private static boolean hasSpread(@NotNull ResolvedValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "hasSpread"));
        }
        List<ValueArgument> arguments = argument.getArguments();
        return arguments.size() == 1 && arguments.get(0).getSpreadElement() != null;
    }

    @NotNull
    private static List<CompileTimeConstant<?>> resolveValueArguments(@NotNull ResolvedValueArgument resolvedValueArgument, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        if (resolvedValueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValueArgument", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        ArrayList<CompileTimeConstant<?>> constants = Lists.newArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            if (argumentExpression == null) continue;
            CompileTimeConstant<? extends Object> constant = ConstantExpressionEvaluator.OBJECT$.evaluate(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                JetType defaultType = ((IntegerValueTypeConstant)constant).getType(expectedType);
                ArgumentTypeResolver.updateNumberType(defaultType, argumentExpression, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            AnnotationResolver.checkCompileTimeConstant(argumentExpression, expectedType, trace);
        }
        ArrayList<CompileTimeConstant<?>> arrayList = constants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        return arrayList;
    }

    @NotNull
    public Annotations getResolvedAnnotations(@NotNull List<JetAnnotationEntry> annotations, @NotNull BindingTrace trace) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
        }
        ArrayList<AnnotationDescriptor> result2 = new ArrayList<AnnotationDescriptor>(annotations.size());
        for (JetAnnotationEntry annotation : annotations) {
            AnnotationDescriptor annotationDescriptor = trace.get(BindingContext.ANNOTATION, annotation);
            if (annotationDescriptor == null) {
                throw new IllegalStateException("Annotation for annotation should have been resolved: \n" + JetPsiUtil.getElementTextWithContext(annotation));
            }
            result2.add(annotationDescriptor);
        }
        AnnotationsImpl annotationsImpl = new AnnotationsImpl(result2);
        if (annotationsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
        }
        return annotationsImpl;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull JetTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        JetModifierList modifierList = jetTypeParameter.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }
}

