/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.plugin.JetLanguage;

public abstract class JetStubElementType<StubT extends StubElement, PsiT extends JetElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public JetStubElementType(@NotNull @NonNls String debugName, final @NotNull Class<PsiT> psiClass, @NotNull Class<?> stubClass) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        if (stubClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubClass", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        super(debugName, JetLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (JetElementImplStub[])Array.newInstance(psiClass, 0);
        this.arrayFactory = new ArrayFactory<PsiT>(){

            @Override
            @NotNull
            public PsiT[] create(int count) {
                if (count == 0) {
                    JetElementImplStub[] jetElementImplStubArray = JetStubElementType.this.emptyArray;
                    if (jetElementImplStubArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType$1", "create"));
                    }
                    return jetElementImplStubArray;
                }
                JetElementImplStub[] jetElementImplStubArray = (JetElementImplStub[])Array.newInstance(psiClass, count);
                if (jetElementImplStubArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType$1", "create"));
                }
                return jetElementImplStubArray;
            }
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsiFromAst"));
        }
        JetElementImplStub jetElementImplStub = (JetElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, node);
        if (jetElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsiFromAst"));
        }
        return (PsiT)jetElementImplStub;
    }

    @Override
    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsi"));
        }
        JetElementImplStub jetElementImplStub = (JetElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, stub);
        if (jetElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsi"));
        }
        return (PsiT)jetElementImplStub;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "jet." + this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "getExternalId"));
        }
        return string;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof JetClassOrObject) {
            return true;
        }
        if (psi instanceof JetFunction) {
            return !((JetFunction)psi).isLocal();
        }
        if (psi instanceof JetProperty) {
            return !((JetProperty)psi).isLocal();
        }
        return JetStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        IElementType parentType = parent.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent);
        }
        return parentType instanceof IStubFileElementType;
    }

    @Override
    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "indexStub"));
        }
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        ArrayFactory<PsiT> arrayFactory = this.arrayFactory;
        if (arrayFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "getArrayFactory"));
        }
        return arrayFactory;
    }
}

