/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.PsiPackage;
import org.jetbrains.jet.lexer.JetTokens;

public class JetObjectDeclarationName
extends JetExpressionImpl {
    public JetObjectDeclarationName(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetObjectDeclarationName", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetObjectDeclarationName", "setName"));
        }
        return this.getNameIdentifier().replace(PsiPackage.JetPsiFactory(this).createNameIdentifier(name));
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetObjectDeclarationName", "accept"));
        }
        return visitor.visitObjectDeclarationName(this, data2);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)this, JetObjectDeclaration.class);
        SearchScope searchScope = objectDeclaration != null ? objectDeclaration.getUseScope() : super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetObjectDeclarationName", "getUseScope"));
        }
        return searchScope;
    }
}

