/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.addRemoveModifier.AddRemoveModifierPackage;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

abstract class JetDeclarationImpl
extends JetExpressionImpl
implements JetDeclaration {
    public JetDeclarationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "hasModifier"));
        }
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "addModifier"));
        }
        AddRemoveModifierPackage.addModifier(this, modifier, JetTokens.INTERNAL_KEYWORD);
    }

    @Override
    public void removeModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "removeModifier"));
        }
        AddRemoveModifierPackage.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotationEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "getAnnotationEntries"));
            }
            return list;
        }
        List<JetAnnotationEntry> list = modifierList.getAnnotationEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "getAnnotationEntries"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotation> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "getAnnotations"));
            }
            return list;
        }
        List<JetAnnotation> list = modifierList.getAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationImpl", "getAnnotations"));
        }
        return list;
    }
}

