/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralArgument;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;

public class JetCallExpression
extends JetExpressionImpl
implements JetCallElement,
JetReferenceExpression {
    public JetCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetCallExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetCallExpression", "accept"));
        }
        return visitor.visitCallExpression(this, data2);
    }

    @Override
    @Nullable
    public JetExpression getCalleeExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.findChildByType(JetNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
        List<JetFunctionLiteralArgument> list = this.findChildrenByType(JetNodeTypes.FUNCTION_LITERAL_ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<Object> valueArgumentsInParentheses = list != null ? list.getArguments() : Collections.emptyList();
        List<JetFunctionLiteralArgument> functionLiteralArguments = this.getFunctionLiteralArguments();
        if (functionLiteralArguments.isEmpty()) {
            List<Object> list2 = valueArgumentsInParentheses;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getValueArguments"));
            }
            return list2;
        }
        ArrayList<Object> allValueArguments2 = Lists.newArrayList();
        allValueArguments2.addAll(valueArgumentsInParentheses);
        allValueArguments2.addAll(functionLiteralArguments);
        ArrayList<Object> arrayList = allValueArguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getValueArguments"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList list = this.getTypeArgumentList();
        List<JetTypeProjection> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getTypeArguments"));
        }
        return list2;
    }
}

