/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.jet.lang.cfg.BlockInfo;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.psi.JetElement;

public class BreakableBlockInfo
extends BlockInfo {
    private final JetElement element;
    private final Label entryPoint;
    private final Label exitPoint;
    private final Set<Label> referablePoints = Sets.newHashSet();

    public BreakableBlockInfo(JetElement element, Label entryPoint, Label exitPoint) {
        this.element = element;
        this.entryPoint = entryPoint;
        this.exitPoint = exitPoint;
        this.markReferablePoints(entryPoint, exitPoint);
    }

    protected void markReferablePoints(Label ... labels) {
        Collections.addAll(this.referablePoints, labels);
    }

    public JetElement getElement() {
        return this.element;
    }

    public Label getEntryPoint() {
        return this.entryPoint;
    }

    public Label getExitPoint() {
        return this.exitPoint;
    }

    public Set<Label> getReferablePoints() {
        return this.referablePoints;
    }
}

