/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AccessorForPropertyBackingFieldInOuterClass;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.annotations.AnnotationsPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class StackValue {
    @NotNull
    public final Type type;

    protected StackValue(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue", "<init>"));
        }
        this.type = type;
    }

    public abstract void put(Type var1, InstructionAdapter var2);

    protected void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
        this.put(type, v);
    }

    public void store(Type topOfStackType, InstructionAdapter v) {
        throw new UnsupportedOperationException("cannot store to value " + this);
    }

    public void dupReceiver(InstructionAdapter v) {
    }

    public int receiverSize() {
        return 0;
    }

    public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
        this.put(this.type, v);
        this.coerceTo(Type.BOOLEAN_TYPE, v);
        if (jumpIfFalse) {
            v.ifeq(label);
        } else {
            v.ifne(label);
        }
    }

    public static Local local(int index, Type type) {
        return new Local(index, type);
    }

    public static StackValue shared(int index, Type type) {
        return new Shared(index, type);
    }

    public static StackValue onStack(Type type) {
        return type == Type.VOID_TYPE ? StackValue.none() : new OnStack(type);
    }

    public static StackValue constant(@Nullable Object value, Type type) {
        return new Constant(value, type);
    }

    public static StackValue cmp(IElementType opToken, Type type) {
        return type.getSort() == 10 ? new ObjectCompare(opToken, type) : new NumberCompare(opToken, type);
    }

    public static StackValue not(StackValue stackValue) {
        return new Invert(stackValue);
    }

    @NotNull
    public static StackValue arrayElement(Type type) {
        ArrayElement arrayElement = new ArrayElement(type);
        if (arrayElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "arrayElement"));
        }
        return arrayElement;
    }

    @NotNull
    public static StackValue collectionElement(Type type, ResolvedCall<FunctionDescriptor> getter, ResolvedCall<FunctionDescriptor> setter, ExpressionCodegen codegen, GenerationState state) {
        CollectionElement collectionElement = new CollectionElement(type, getter, setter, codegen, state);
        if (collectionElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "collectionElement"));
        }
        return collectionElement;
    }

    @NotNull
    public static Field field(@NotNull Type type, @NotNull Type owner, @NotNull String name, boolean isStatic) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        Field field = new Field(type, owner, name, isStatic);
        if (field == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        return field;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor, @NotNull Type methodOwner, @NotNull Type type, boolean isStatic, @Nullable String fieldName, @Nullable CallableMethod getter, @Nullable CallableMethod setter, GenerationState state) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        if (methodOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOwner", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        Property property2 = new Property(descriptor, methodOwner, getter, setter, isStatic, fieldName, type, state);
        if (property2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        return property2;
    }

    @NotNull
    public static StackValue expression(Type type, JetExpression expression, ExpressionCodegen generator) {
        Expression expression2 = new Expression(type, expression, generator);
        if (expression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "expression"));
        }
        return expression2;
    }

    private static void box(Type type, Type toType, InstructionAdapter v) {
        if (type == Type.BYTE_TYPE || toType.getInternalName().equals("java/lang/Byte") && type == Type.INT_TYPE) {
            v.cast(type, Type.BYTE_TYPE);
            v.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type == Type.SHORT_TYPE || toType.getInternalName().equals("java/lang/Short") && type == Type.INT_TYPE) {
            v.cast(type, Type.SHORT_TYPE);
            v.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type == Type.LONG_TYPE || toType.getInternalName().equals("java/lang/Long") && type == Type.INT_TYPE) {
            v.cast(type, Type.LONG_TYPE);
            v.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type == Type.INT_TYPE) {
            v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type == Type.CHAR_TYPE) {
            v.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (type == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        }
    }

    private static void unbox(Type type, InstructionAdapter v) {
        if (type == Type.INT_TYPE) {
            v.invokevirtual("java/lang/Number", "intValue", "()I", false);
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokevirtual("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type == Type.CHAR_TYPE) {
            v.invokevirtual("java/lang/Character", "charValue", "()C", false);
        } else if (type == Type.SHORT_TYPE) {
            v.invokevirtual("java/lang/Number", "shortValue", "()S", false);
        } else if (type == Type.LONG_TYPE) {
            v.invokevirtual("java/lang/Number", "longValue", "()J", false);
        } else if (type == Type.BYTE_TYPE) {
            v.invokevirtual("java/lang/Number", "byteValue", "()B", false);
        } else if (type == Type.FLOAT_TYPE) {
            v.invokevirtual("java/lang/Number", "floatValue", "()F", false);
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokevirtual("java/lang/Number", "doubleValue", "()D", false);
        }
    }

    protected void coerceTo(Type toType, InstructionAdapter v) {
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(Type topOfStackType, InstructionAdapter v) {
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(Type fromType, Type toType, InstructionAdapter v) {
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypeConstants.UNIT_TYPE) || toType.equals(AsmTypeConstants.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypeConstants.UNIT_TYPE)) {
            if (fromType.equals(AsmTypeConstants.getType(Object.class))) {
                v.checkcast(AsmTypeConstants.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypeConstants.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypeConstants.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            if (fromType.equals(AsmTypeConstants.getType(Boolean.class)) || fromType.equals(AsmTypeConstants.getType(Character.class))) {
                StackValue.unbox(AsmUtil.unboxType(fromType), v);
                StackValue.coerce(AsmUtil.unboxType(fromType), toType, v);
            } else {
                if (toType.getSort() == 1 || toType.getSort() == 2) {
                    StackValue.coerce(fromType, AsmUtil.boxType(toType), v);
                } else {
                    StackValue.coerce(fromType, AsmTypeConstants.getType(Number.class), v);
                }
                StackValue.unbox(toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(InstructionAdapter v) {
        v.visitFieldInsn(178, AsmTypeConstants.UNIT_TYPE.getInternalName(), "INSTANCE$", AsmTypeConstants.UNIT_TYPE.getDescriptor());
    }

    protected void putAsBoolean(InstructionAdapter v) {
        Label ifTrue = new Label();
        Label end = new Label();
        this.condJump(ifTrue, false, v);
        v.iconst(0);
        v.goTo(end);
        v.mark(ifTrue);
        v.iconst(1);
        v.mark(end);
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static StackValue fieldForSharedVar(Type localType, Type classType, String fieldName) {
        return new FieldForSharedVar(localType, classType, fieldName);
    }

    public static StackValue composed(StackValue prefix, StackValue suffix) {
        return new Composed(prefix, suffix);
    }

    public static StackValue thisOrOuter(ExpressionCodegen codegen, ClassDescriptor descriptor, boolean isSuper, boolean isExplicit) {
        boolean coerceType = descriptor.getKind() == ClassKind.TRAIT || isExplicit && !isSuper;
        return new ThisOuter(codegen, descriptor, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index, int increment) {
        return new PostIncrement(index, increment);
    }

    public static StackValue preIncrement(int index, int increment) {
        return new PreIncrement(index, increment);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall, StackValue receiver, ExpressionCodegen codegen, @Nullable CallableMethod callableMethod) {
        if (resolvedCall.getDispatchReceiver().exists() || resolvedCall.getExtensionReceiver().exists() || StackValue.isLocalFunCall(callableMethod)) {
            return new CallReceiver(resolvedCall, receiver, codegen, callableMethod, true);
        }
        return receiver;
    }

    @Contract(value="null -> false")
    private static boolean isLocalFunCall(@Nullable CallableMethod callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            CallReceiver callReceiver = (CallReceiver)receiverWithParameter;
            return new CallReceiver(callReceiver.resolvedCall, callReceiver.receiver, callReceiver.codegen, callReceiver.callableMethod, false);
        }
        return receiverWithParameter;
    }

    public static Field singleton(ClassDescriptor classDescriptor, JetTypeMapper typeMapper) {
        FieldInfo info = FieldInfo.createForSingleton(classDescriptor, typeMapper);
        return StackValue.field(info.getFieldType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), true);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value) {
        return value instanceof Local || value instanceof Constant;
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
        }
        switch (type.getSort()) {
            case 9: 
            case 10: {
                Type type2 = AsmTypeConstants.OBJECT_REF_TYPE;
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type2;
            }
            case 3: {
                Type type3 = Type.getObjectType("kotlin/jvm/internal/Ref$ByteRef");
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type3;
            }
            case 4: {
                Type type4 = Type.getObjectType("kotlin/jvm/internal/Ref$ShortRef");
                if (type4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type4;
            }
            case 2: {
                Type type5 = Type.getObjectType("kotlin/jvm/internal/Ref$CharRef");
                if (type5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type5;
            }
            case 5: {
                Type type6 = Type.getObjectType("kotlin/jvm/internal/Ref$IntRef");
                if (type6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type6;
            }
            case 7: {
                Type type7 = Type.getObjectType("kotlin/jvm/internal/Ref$LongRef");
                if (type7 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type7;
            }
            case 1: {
                Type type8 = Type.getObjectType("kotlin/jvm/internal/Ref$BooleanRef");
                if (type8 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type8;
            }
            case 6: {
                Type type9 = Type.getObjectType("kotlin/jvm/internal/Ref$FloatRef");
                if (type9 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type9;
            }
            case 8: {
                Type type10 = Type.getObjectType("kotlin/jvm/internal/Ref$DoubleRef");
                if (type10 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "sharedTypeForType"));
                }
                return type10;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Type refType(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return AsmTypeConstants.OBJECT_TYPE;
        }
        return type;
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStatic;

        public StackValueWithSimpleReceiver(@NotNull Type type, boolean isStatic) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            super(type);
            this.isStatic = isStatic;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (!this.isStatic) {
                v.dup();
            }
        }

        @Override
        public int receiverSize() {
            return this.isStatic ? 0 : 1;
        }
    }

    public static class CallReceiver
    extends StackValue {
        private final ResolvedCall<?> resolvedCall;
        private final StackValue receiver;
        private final ExpressionCodegen codegen;
        private final CallableMethod callableMethod;
        private final boolean putReceiverArgumentOnStack;

        public CallReceiver(@NotNull ResolvedCall<?> resolvedCall, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable CallableMethod callableMethod, boolean putReceiverArgumentOnStack) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "<init>"));
            }
            super(CallReceiver.calcType(resolvedCall, codegen.typeMapper, callableMethod));
            this.resolvedCall = resolvedCall;
            this.receiver = receiver;
            this.codegen = codegen;
            this.callableMethod = callableMethod;
            this.putReceiverArgumentOnStack = putReceiverArgumentOnStack;
        }

        private static Type calcType(@NotNull ResolvedCall<?> resolvedCall, @NotNull JetTypeMapper typeMapper, @Nullable CallableMethod callableMethod) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "calcType"));
            }
            if (typeMapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "calcType"));
            }
            Object descriptor = resolvedCall.getResultingDescriptor();
            ReceiverParameterDescriptor dispatchReceiver = descriptor.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiver2 = descriptor.getExtensionReceiverParameter();
            if (extensionReceiver2 != null) {
                return callableMethod != null ? callableMethod.getReceiverClass() : typeMapper.mapType(extensionReceiver2.getType());
            }
            if (dispatchReceiver != null) {
                return callableMethod != null ? callableMethod.getThisType() : typeMapper.mapType(dispatchReceiver.getType());
            }
            if (StackValue.isLocalFunCall(callableMethod)) {
                return callableMethod.getGenerateCalleeType();
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            Object descriptor = this.resolvedCall.getResultingDescriptor();
            ReceiverValue dispatchReceiver = this.resolvedCall.getDispatchReceiver();
            ReceiverValue extensionReceiver2 = this.resolvedCall.getExtensionReceiver();
            int depth = 0;
            if (dispatchReceiver.exists()) {
                if (!AnnotationsPackage.isPlatformStaticInObject(descriptor)) {
                    if (extensionReceiver2.exists()) {
                        Type resultType = this.callableMethod != null ? this.callableMethod.getOwner() : this.codegen.typeMapper.mapType(descriptor.getDispatchReceiverParameter().getType());
                        this.codegen.generateReceiverValue(dispatchReceiver, resultType);
                    } else {
                        this.genReceiver(v, dispatchReceiver, type, null, 0);
                    }
                    depth = 1;
                }
            } else if (StackValue.isLocalFunCall(this.callableMethod)) {
                assert (this.receiver == CallReceiver.none() || extensionReceiver2.exists()) : "Receiver should be present only for local extension function: " + this.callableMethod;
                StackValue value = this.codegen.findLocalOrCapturedValue(descriptor.getOriginal());
                assert (value != null) : "Local fun should be found in locals or in captured params: " + this.resolvedCall;
                value.put(this.callableMethod.getGenerateCalleeType(), v);
                depth = 1;
            }
            if (this.putReceiverArgumentOnStack && extensionReceiver2.exists()) {
                this.genReceiver(v, extensionReceiver2, type, descriptor.getExtensionReceiverParameter(), depth);
            }
        }

        private void genReceiver(@NotNull InstructionAdapter v, @NotNull ReceiverValue receiverArgument, @NotNull Type type, @Nullable ReceiverParameterDescriptor receiverParameter, int depth) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "genReceiver"));
            }
            if (receiverArgument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "genReceiver"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue$CallReceiver", "genReceiver"));
            }
            if (this.receiver == StackValue.none()) {
                if (receiverParameter != null) {
                    Type receiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    this.codegen.generateReceiverValue(receiverArgument, receiverType);
                    StackValue.onStack(receiverType).put(type, v);
                } else {
                    this.codegen.generateReceiverValue(receiverArgument, type);
                }
            } else {
                this.receiver.moveToTopOfStack(type, v, depth);
            }
        }
    }

    private static class PreIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.iinc(this.index, this.increment);
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor, boolean isSuper, boolean coerceType) {
            super(AsmTypeConstants.OBJECT_TYPE);
            this.codegen = codegen;
            this.descriptor = descriptor;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type : stackValue.type, v);
        }
    }

    public static class Composed
    extends StackValue {
        public final StackValue prefix;
        public final StackValue suffix;

        public Composed(StackValue prefix, StackValue suffix) {
            super(suffix.type);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.prefix.put(this.prefix.type, v);
            this.suffix.put(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.prefix.put(AsmTypeConstants.OBJECT_TYPE, v);
            this.suffix.store(topOfStackType, v);
        }
    }

    static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;

        public FieldForSharedVar(Type type, Type owner, String name) {
            super(type, false);
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }
    }

    public static class Shared
    extends StackValue {
        private final int index;
        private boolean isReleaseOnPut = false;

        public Shared(int index, Type type) {
            super(type);
            this.index = index;
        }

        public void releaseOnPut() {
            this.isReleaseOnPut = true;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, AsmTypeConstants.OBJECT_TYPE);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type, v);
            if (this.isReleaseOnPut) {
                v.aconst(null);
                v.store(this.index, AsmTypeConstants.OBJECT_TYPE);
            }
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.load(this.index, AsmTypeConstants.OBJECT_TYPE);
            AsmUtil.swap(v, Shared.sharedTypeForType(this.type), topOfStackType);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final JetExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type, JetExpression expression, ExpressionCodegen generator) {
            super(type);
            this.expression = expression;
            this.generator = generator;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.generator.gen(this.expression, type);
        }
    }

    static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type methodOwner;
        private final PropertyDescriptor descriptor;
        private final GenerationState state;
        private final String fieldName;

        public Property(@NotNull PropertyDescriptor descriptor, @NotNull Type methodOwner, @Nullable CallableMethod getter, @Nullable CallableMethod setter, boolean isStatic, @Nullable String fieldName, @NotNull Type type, @NotNull GenerationState state) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (methodOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOwner", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            super(type, isStatic);
            this.methodOwner = methodOwner;
            this.getter = getter;
            this.setter = setter;
            this.descriptor = descriptor;
            this.state = state;
            this.fieldName = fieldName;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                v.visitFieldInsn(this.isStatic ? 178 : 180, this.methodOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                AsmUtil.genNotNullAssertionForField(v, this.state, this.descriptor);
                this.coerceTo(type, v);
            } else {
                this.getter.invokeWithoutAssertions(v);
                Property.coerce(this.getter.getAsmMethod().getReturnType(), type, v);
            }
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            if (this.setter == null) {
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                v.visitFieldInsn(this.isStatic ? 179 : 181, this.methodOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                this.setter.invokeWithoutAssertions(v);
            }
        }

        public boolean isPropertyWithBackingFieldInOuterClass() {
            return this.descriptor instanceof AccessorForPropertyBackingFieldInOuterClass;
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;

        public Field(Type type, Type owner, String name, boolean isStatic) {
            super(type, isStatic);
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.visitFieldInsn(this.isStatic ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStatic ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }
    }

    private static class CollectionElement
    extends StackValue {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final GenerationState state;
        private final FrameMap frame;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private final FunctionDescriptor setterDescriptor;
        private final FunctionDescriptor getterDescriptor;

        public CollectionElement(Type type, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, ExpressionCodegen codegen, GenerationState state) {
            super(type);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.state = state;
            this.setterDescriptor = resolvedSetCall == null ? null : resolvedSetCall.getResultingDescriptor();
            this.getterDescriptor = resolvedGetCall == null ? null : resolvedGetCall.getResultingDescriptor();
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(this.setterDescriptor, false);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(this.getterDescriptor, false);
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            if (this.getter instanceof CallableMethod) {
                ((CallableMethod)this.getter).invokeWithNotNullAssertion(v, this.state, this.resolvedGetCall);
            } else {
                ((IntrinsicMethod)this.getter).generate(this.codegen, v, this.type, null, null, null);
            }
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            if (this.setter instanceof CallableMethod) {
                CallableMethod method = (CallableMethod)this.setter;
                Method asmMethod = method.getAsmMethod();
                Type[] argumentTypes = asmMethod.getArgumentTypes();
                CollectionElement.coerce(topOfStackType, argumentTypes[argumentTypes.length - 1], v);
                method.invokeWithNotNullAssertion(v, this.state, this.resolvedSetCall);
                Type returnType = asmMethod.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType);
                }
            } else {
                ((IntrinsicMethod)this.setter).generate(this.codegen, v, null, null, null, null);
            }
        }

        @Override
        public int receiverSize() {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            Type type;
            int realReceiverIndex;
            Type realReceiverType;
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMap.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters.size() - 1; i >= 0; --i) {
                Type type2 = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type2);
                v.store(firstParamIndex, type2);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter.exists()) {
                Type type3 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type3);
                v.store(receiverIndex, type3);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver.exists()) {
                thisIndex = this.frame.enterTemp(AsmTypeConstants.OBJECT_TYPE);
                v.store(thisIndex, AsmTypeConstants.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypeConstants.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver().exists()) {
                if (this.resolvedSetCall.getExtensionReceiver().exists()) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), AsmTypeConstants.OBJECT_TYPE);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver().exists()) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index, type);
                index -= type.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypeConstants.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index, type);
                index -= type.getSize();
            }
            mark.dropTo();
        }

        private boolean isStandardStack(ResolvedCall<?> call, int valueParamsSize) {
            if (call == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.codegen.typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call.getDispatchReceiver().exists() ? call.getExtensionReceiver().exists() : this.codegen.typeMapper.mapType(call.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }
    }

    private static class ArrayElement
    extends StackValue {
        public ArrayElement(Type type) {
            super(type);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.aload(this.type);
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.astore(this.type);
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            v.dup2();
        }

        @Override
        public int receiverSize() {
            return 2;
        }
    }

    private static class Invert
    extends StackValue {
        private final StackValue myOperand;

        private Invert(StackValue operand) {
            super(Type.BOOLEAN_TYPE);
            this.myOperand = operand;
            if (this.myOperand.type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("operand of ! must be boolean");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.putAsBoolean(v);
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            this.myOperand.condJump(label, !jumpIfFalse, v);
        }
    }

    private static class ObjectCompare
    extends NumberCompare {
        public ObjectCompare(IElementType opToken, Type operandType) {
            super(opToken, operandType);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQEQ) {
                opcode = jumpIfFalse ? 166 : 165;
            } else if (this.opToken == JetTokens.EXCLEQEQEQ) {
                opcode = jumpIfFalse ? 165 : 166;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    private static class NumberCompare
    extends StackValue {
        protected final IElementType opToken;
        private final Type operandType;

        public NumberCompare(IElementType opToken, Type operandType) {
            super(Type.BOOLEAN_TYPE);
            this.opToken = opToken;
            this.operandType = operandType;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.putAsBoolean(v);
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQ) {
                opcode = jumpIfFalse ? 154 : 153;
            } else if (this.opToken == JetTokens.EXCLEQ) {
                opcode = jumpIfFalse ? 153 : 154;
            } else if (this.opToken == JetTokens.GT) {
                opcode = jumpIfFalse ? 158 : 157;
            } else if (this.opToken == JetTokens.GTEQ) {
                opcode = jumpIfFalse ? 155 : 156;
            } else if (this.opToken == JetTokens.LT) {
                opcode = jumpIfFalse ? 156 : 155;
            } else if (this.opToken == JetTokens.LTEQ) {
                opcode = jumpIfFalse ? 157 : 158;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            if (this.operandType == Type.FLOAT_TYPE || this.operandType == Type.DOUBLE_TYPE) {
                if (this.opToken == JetTokens.GT || this.opToken == JetTokens.GTEQ) {
                    v.cmpl(this.operandType);
                } else {
                    v.cmpg(this.operandType);
                }
            } else if (this.operandType == Type.LONG_TYPE) {
                v.lcmp();
            } else {
                opcode += 6;
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        private final Object value;

        public Constant(@Nullable Object value, Type type) {
            super(type);
            this.value = value;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.value instanceof Integer) {
                v.iconst((Integer)this.value);
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            if (this.value instanceof Boolean) {
                boolean boolValue = (Boolean)this.value;
                if (boolValue ^ jumpIfFalse) {
                    v.goTo(label);
                }
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type) {
            super(type);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.coerceTo(type, v);
        }

        @Override
        public void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
            if (depth == 0) {
                this.put(type, v);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type + " to top of stack");
                }
                this.coerceTo(type, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index, Type type) {
            super(type);
            this.index = index;
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, this.type);
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.coerceTo(type, v);
        }
    }
}

