/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.ParentCodegenAware;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.LocalLookup;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.diagnostics.DiagnosticsPackage;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ClosureCodegen
extends ParentCodegenAware {
    private final PsiElement fun;
    private final FunctionDescriptor funDescriptor;
    private final SamType samType;
    private final JetType superClassType;
    private final List<JetType> superInterfaceTypes;
    private final CodegenContext context;
    private final FunctionGenerationStrategy strategy;
    private final CalculatedClosure closure;
    private final Type asmType;
    private final int visibilityFlag;
    private final JvmAnnotationNames.KotlinSyntheticClass.Kind syntheticClassKind;
    private Method constructor;

    public ClosureCodegen(@NotNull GenerationState state, @NotNull PsiElement fun, @NotNull FunctionDescriptor funDescriptor, @Nullable SamType samType, @NotNull CodegenContext parentContext, @NotNull JvmAnnotationNames.KotlinSyntheticClass.Kind syntheticClassKind, @NotNull LocalLookup localLookup, @NotNull FunctionGenerationStrategy strategy, @Nullable MemberCodegen<?> parentCodegen) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (syntheticClassKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticClassKind", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (localLookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localLookup", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.fun = fun;
        this.funDescriptor = funDescriptor;
        this.samType = samType;
        this.context = parentContext.intoClosure(funDescriptor, localLookup, this.typeMapper);
        this.syntheticClassKind = syntheticClassKind;
        this.strategy = strategy;
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(this.bindingContext, funDescriptor);
        if (samType == null) {
            this.superInterfaceTypes = new ArrayList<JetType>();
            JetType superClassType = null;
            for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
                ClassifierDescriptor classifier2 = supertype.getConstructor().getDeclarationDescriptor();
                if (DescriptorUtils.isTrait(classifier2)) {
                    this.superInterfaceTypes.add(supertype);
                    continue;
                }
                assert (superClassType == null) : "Closure class can't have more than one superclass: " + funDescriptor;
                superClassType = supertype;
            }
            assert (superClassType != null) : "Closure class should have a superclass: " + funDescriptor;
            this.superClassType = superClassType;
        } else {
            this.superInterfaceTypes = Collections.singletonList(samType.getType());
            this.superClassType = KotlinBuiltIns.getInstance().getAnyType();
        }
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + classDescriptor;
        this.asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, funDescriptor);
        this.visibilityFlag = AsmUtil.getVisibilityAccessFlagForAnonymous(classDescriptor);
    }

    public void gen() {
        ClassBuilder cv = this.state.getFactory().newVisitor(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), this.asmType, this.fun.getContainingFile());
        FunctionDescriptor erasedInterfaceFunction = this.samType == null ? ClosureCodegen.getErasedInvokeFunction(this.funDescriptor) : this.samType.getAbstractMethod().getOriginal();
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        if (this.samType != null) {
            this.typeMapper.writeFormalTypeParameters(this.samType.getType().getConstructor().getParameters(), sw);
        }
        sw.writeSuperclass();
        Type superClassAsmType = this.typeMapper.mapSupertype(this.superClassType, sw);
        sw.writeSuperclassEnd();
        String[] superInterfaceAsmTypes = new String[this.superInterfaceTypes.size()];
        for (int i = 0; i < this.superInterfaceTypes.size(); ++i) {
            JetType superInterfaceType = this.superInterfaceTypes.get(i);
            sw.writeInterface();
            superInterfaceAsmTypes[i] = this.typeMapper.mapSupertype(superInterfaceType, sw).getInternalName();
            sw.writeInterfaceEnd();
        }
        cv.defineClass(this.fun, 50, 0x30 | this.visibilityFlag, this.asmType.getInternalName(), sw.makeJavaGenericSignature(), superClassAsmType.getInternalName(), superInterfaceAsmTypes);
        cv.visitSource(this.fun.getContainingFile().getName(), null);
        AsmUtil.writeKotlinSyntheticClassAnnotation(cv, this.syntheticClassKind);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(this.funDescriptor).replaceName(erasedInterfaceFunction.getName().toString());
        this.generateBridge(cv, this.typeMapper.mapSignature(erasedInterfaceFunction).getAsmMethod(), jvmMethodSignature.getAsmMethod());
        FunctionCodegen fc = new FunctionCodegen(this.context, cv, this.state, this.getParentCodegen());
        fc.generateMethod(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), jvmMethodSignature, this.funDescriptor, this.strategy);
        if (this.samType != null) {
            SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(this.funDescriptor.getContainingDeclaration(), this.funDescriptor.getAnnotations(), erasedInterfaceFunction.getName(), CallableMemberDescriptor.Kind.DECLARATION, this.funDescriptor.getSource());
            descriptorForBridges.initialize((JetType)null, erasedInterfaceFunction.getDispatchReceiverParameter(), erasedInterfaceFunction.getTypeParameters(), (List)erasedInterfaceFunction.getValueParameters(), erasedInterfaceFunction.getReturnType(), Modality.OPEN, erasedInterfaceFunction.getVisibility());
            descriptorForBridges.addOverriddenDescriptor(erasedInterfaceFunction);
            fc.generateBridges(descriptorForBridges);
        }
        this.constructor = this.generateConstructor(cv, superClassAsmType);
        if (JvmCodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(cv);
        }
        AsmUtil.genClosureFields(this.closure, cv, this.typeMapper);
        fc.generateDefaultIfNeeded(this.context.intoFunction(this.funDescriptor), this.typeMapper.mapSignature(this.funDescriptor), this.funDescriptor, this.context.getContextKind(), DefaultParameterValueLoader.DEFAULT, null);
        AsmUtil.writeOuterClassAndEnclosingMethod(CodegenBinding.anonymousClassForFunction(this.bindingContext, this.funDescriptor), this.funDescriptor, this.typeMapper, cv);
        cv.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        if (JvmCodegenUtil.isConst(this.closure)) {
            v.getstatic(this.asmType.getInternalName(), "INSTANCE$", this.asmType.getDescriptor());
        } else {
            v.anew(this.asmType);
            v.dup();
            codegen.pushClosureOnStack(this.closure, false, codegen.defaultCallGenerator);
            v.invokespecial(this.asmType.getInternalName(), "<init>", this.constructor.getDescriptor(), false);
        }
        StackValue stackValue = StackValue.onStack(this.asmType);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        return stackValue;
    }

    private void generateConstInstance(@NotNull ClassBuilder cv) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstInstance"));
        }
        MethodVisitor mv = cv.newMethod(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), 4104, "<clinit>", "()V", null, ArrayUtil.EMPTY_STRING_ARRAY);
        InstructionAdapter iv = new InstructionAdapter(mv);
        cv.newField(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), 24, "INSTANCE$", this.asmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            iv.anew(this.asmType);
            iv.dup();
            iv.invokespecial(this.asmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(this.asmType.getInternalName(), "INSTANCE$", this.asmType.getDescriptor());
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "<clinit>", this.fun);
        }
    }

    private void generateBridge(@NotNull ClassBuilder cv, @NotNull Method bridge, @NotNull Method delegate2) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (bridge.equals(delegate2)) {
            return;
        }
        MethodVisitor mv = cv.newMethod(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), 65, bridge.getName(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, this.asmType);
        ReceiverParameterDescriptor receiver = this.funDescriptor.getExtensionReceiverParameter();
        int count = 1;
        if (receiver != null) {
            StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(receiver.getType()), iv);
            ++count;
        }
        List<ValueParameterDescriptor> params = this.funDescriptor.getValueParameters();
        for (ValueParameterDescriptor param : params) {
            StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(param.getType()), iv);
            ++count;
        }
        iv.invokevirtual(this.asmType.getInternalName(), delegate2.getName(), delegate2.getDescriptor(), false);
        StackValue.onStack(delegate2.getReturnType()).put(bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge", this.fun);
    }

    @NotNull
    private Method generateConstructor(@NotNull ClassBuilder cv, @NotNull Type superClassAsmType) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        if (superClassAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassAsmType", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.closure, this.asmType);
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = cv.newMethod(DiagnosticsPackage.OtherOrigin(this.fun, this.funDescriptor), this.visibilityFlag, "<init>", constructor.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            int k = 1;
            for (FieldInfo fieldInfo : args) {
                k = AsmUtil.genAssignInstanceFieldFromParam(fieldInfo, k, iv);
            }
            iv.load(0, superClassAsmType);
            iv.invokespecial(superClassAsmType.getInternalName(), "<init>", "()V", false);
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor", this.fun);
        }
        Method method = constructor;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        return method;
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull JetTypeMapper typeMapper, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        JetType captureReceiverType;
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        BindingContext bindingContext = typeMapper.getBindingContext();
        ArrayList<FieldInfo> args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            Type type = typeMapper.mapType(captureThis);
            args.add(FieldInfo.createForHiddenField(ownerType, type, "this$0"));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper.mapType(captureReceiverType), "receiver$0"));
        }
        for (DeclarationDescriptor descriptor : closure.getCaptureVariables().keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = typeMapper.getSharedVarType(descriptor);
                Type type = sharedVarType != null ? sharedVarType : typeMapper.mapType((VariableDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, type, "$" + descriptor.getName().asString()));
                continue;
            }
            if (CodegenBinding.isLocalNamedFun(descriptor)) {
                Type classType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, (FunctionDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, classType, "$" + descriptor.getName().asString()));
                continue;
            }
            if (descriptor instanceof FunctionDescriptor) assert (captureReceiverType != null);
        }
        ArrayList<FieldInfo> arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        return arrayList;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    public static FunctionDescriptor getErasedInvokeFunction(@NotNull FunctionDescriptor funDescriptor) {
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/ClosureCodegen", "getErasedInvokeFunction"));
        }
        int arity = funDescriptor.getValueParameters().size();
        ClassDescriptor funClass = funDescriptor.getExtensionReceiverParameter() == null ? KotlinBuiltIns.getInstance().getFunction(arity) : KotlinBuiltIns.getInstance().getExtensionFunction(arity);
        FunctionDescriptor functionDescriptor = funClass.getDefaultType().getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "getErasedInvokeFunction"));
        }
        return functionDescriptor;
    }
}

