/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.sampullara.cli.Args;
import java.io.PrintStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.Usage;
import org.jetbrains.jet.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.jet.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.jet.cli.common.messages.OutputMessageUtil;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.config.Services;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    @NotNull
    private List<CompilerPlugin> compilerPlugins = Lists.newArrayList();

    @NotNull
    public List<CompilerPlugin> getCompilerPlugins() {
        List<CompilerPlugin> list = this.compilerPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "getCompilerPlugins"));
        }
        return list;
    }

    public void setCompilerPlugins(@NotNull List<CompilerPlugin> compilerPlugins) {
        if (compilerPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerPlugins", "org/jetbrains/jet/cli/common/CLICompiler", "setCompilerPlugins"));
        }
        this.compilerPlugins = compilerPlugins;
    }

    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_WITH_RELATIVE_PATH, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execAndOutputHtml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "execAndOutputHtml"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/jet/cli/common/CLICompiler", "execAndOutputHtml"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "execAndOutputHtml"));
        }
        ExitCode exitCode = this.exec(errStream, services, MessageRenderer.TAGS, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "execAndOutputHtml"));
        }
        return exitCode;
    }

    @Nullable
    private A parseArguments(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        try {
            A arguments = this.createArguments();
            ((CommonCompilerArguments)arguments).freeArgs = Args.parse(arguments, args);
            return arguments;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            this.usage(errStream, false);
        }
        catch (Throwable t) {
            errStream.println(messageRenderer.render(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), CompilerMessageLocation.NO_LOCATION));
        }
        return null;
    }

    protected void usage(@NotNull PrintStream target, boolean extraHelp) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/cli/common/CLICompiler", "usage"));
        }
        Usage.print(target, this.createArguments(), extraHelp);
    }

    protected void configureEnvironment(@NotNull CompilerConfiguration configuration, @NotNull A arguments) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/jet/cli/common/CLICompiler", "configureEnvironment"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "configureEnvironment"));
        }
        configuration.addAll(CLIConfigurationKeys.COMPILER_PLUGINS, this.compilerPlugins);
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        A arguments = this.parseArguments(errStream, messageRenderer, args);
        if (arguments == null) {
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        if (((CommonCompilerArguments)arguments).help || ((CommonCompilerArguments)arguments).extraHelp) {
            this.usage(errStream, ((CommonCompilerArguments)arguments).extraHelp);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        errStream.print(messageRenderer.renderPreamble());
        this.printVersionIfNeeded(errStream, arguments, messageRenderer);
        MessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments).verbose);
        if (((CommonCompilerArguments)arguments).suppressWarnings) {
            collector2 = new FilteringMessageCollector(collector2, Predicates.equalTo(CompilerMessageSeverity.WARNING));
        }
        ExitCode exitCode = this.exec(collector2, services, arguments);
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        finally {
            errStream.print(messageRenderer.renderConclusion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        GroupingMessageCollector groupingCollector = new GroupingMessageCollector(messageCollector);
        Disposable rootDisposable = Disposer.newDisposable();
        MessageSeverityCollector severityCollector = new MessageSeverityCollector(groupingCollector);
        ExitCode code = this.doExecute(arguments, services, severityCollector, rootDisposable);
        ExitCode exitCode = severityCollector.anyReported(CompilerMessageSeverity.ERROR) ? ExitCode.COMPILATION_ERROR : code;
        Disposer.dispose(rootDisposable);
        groupingCollector.flush();
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Disposer.dispose(rootDisposable);
                        throw throwable;
                    }
                    catch (Throwable t) {
                        groupingCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), CompilerMessageLocation.NO_LOCATION);
                        ExitCode exitCode3 = ExitCode.INTERNAL_ERROR;
                        ExitCode exitCode4 = exitCode3;
                        if (exitCode4 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
                        }
                        return exitCode4;
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    groupingCollector.flush();
                }
            }
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull Services var2, @NotNull MessageCollector var3, @NotNull Disposable var4);

    protected void printVersionIfNeeded(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull MessageRenderer messageRenderer) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (((CommonCompilerArguments)arguments).version) {
            String versionMessage = messageRenderer.render(CompilerMessageSeverity.INFO, "Kotlin Compiler version 0.9.66", CompilerMessageLocation.NO_LOCATION);
            errStream.println(versionMessage);
        }
    }

    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/jet/cli/common/CLICompiler", "doMain"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "doMain"));
        }
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        try {
            exitCode = compiler.exec(System.err, args);
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
            }
            return exitCode2;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        return exitCode;
    }
}

