/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetFile;

public class JetCodeBlockModificationListener
implements PsiTreeChangePreprocessor {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.jet.asJava.JetCodeBlockModificationListener");
    private final PsiModificationTrackerImpl myModificationTracker;

    public JetCodeBlockModificationListener(PsiModificationTracker modificationTracker2) {
        this.myModificationTracker = (PsiModificationTrackerImpl)modificationTracker2;
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jet/asJava/JetCodeBlockModificationListener", "treeChanged"));
        }
        if (!(event.getFile() instanceof JetFile)) {
            return;
        }
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: 
            case BEFORE_PROPERTY_CHANGE: 
            case BEFORE_CHILD_MOVEMENT: 
            case BEFORE_CHILD_REPLACEMENT: 
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: {
                break;
            }
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case CHILD_REPLACED: {
                this.processChange(event.getParent(), event.getOldChild(), event.getChild());
                break;
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) break;
                this.processChange(event.getParent(), event.getParent(), null);
                break;
            }
            case CHILD_MOVED: 
            case PROPERTY_CHANGED: {
                this.myModificationTracker.incCounter();
                break;
            }
            default: {
                LOG.error("Unknown code:" + (Object)((Object)event.getCode()));
            }
        }
    }

    private void processChange(PsiElement parent, PsiElement child1, PsiElement child2) {
        try {
            if (!JetCodeBlockModificationListener.isInsideCodeBlock(parent)) {
                if (parent != null && parent.getContainingFile() instanceof JetFile) {
                    this.myModificationTracker.incCounter();
                } else {
                    this.myModificationTracker.incOutOfCodeBlockModificationCounter();
                }
                return;
            }
            if (JetCodeBlockModificationListener.containsClassesInside(child1) || child2 != child1 && JetCodeBlockModificationListener.containsClassesInside(child2)) {
                this.myModificationTracker.incCounter();
            }
        }
        catch (PsiInvalidElementAccessException e) {
            this.myModificationTracker.incCounter();
        }
    }

    private static boolean containsClassesInside(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiClass) {
            return true;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!JetCodeBlockModificationListener.containsClassesInside(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideCodeBlock(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (element == null || element.getParent() == null) {
            return true;
        }
        PsiElement parent = element;
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiDirectory) && parent != null) {
            if (parent instanceof JetClass) {
                return false;
            }
            if (parent instanceof JetBlockExpression) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

