/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kotlin.IntRange;
import kotlin.KotlinNullPointerException;

public class Intrinsics {
    private static final Set<String> METHOD_NAMES_TO_SKIP = new HashSet<String>(Arrays.asList("throwNpe", "checkReturnedValueIsNotNull", "checkFieldIsNotNull", "checkParameterIsNotNull", "throwParameterIsNullException"));

    private Intrinsics() {
    }

    public static String stringPlus(String self, Object other) {
        return String.valueOf(self) + String.valueOf(other);
    }

    public static void throwNpe() {
        throw new KotlinNullPointerException();
    }

    public static void checkExpressionValueIsNotNull(Object value, String message) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException(message + " must not be null");
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkReturnedValueIsNotNull(Object value, String className, String methodName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Method specified as non-null returned null: " + className + "." + methodName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkFieldIsNotNull(Object value, String className, String fieldName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Field specified as non-null is null: " + className + "." + fieldName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkParameterIsNotNull(Object value, String paramName) {
        if (value == null) {
            Intrinsics.throwParameterIsNullException(paramName);
        }
    }

    private static void throwParameterIsNullException(String paramName) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        String className = caller.getClassName();
        String methodName = caller.getMethodName();
        IllegalArgumentException exception = new IllegalArgumentException("Parameter specified as non-null is null: method " + className + "." + methodName + ", parameter " + paramName);
        throw Intrinsics.sanitizeStackTrace(exception);
    }

    public static int compare(long thisVal, long anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(int thisVal, int anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static boolean areEqual(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public static IntRange arrayIndices(int length) {
        return new IntRange(0, length - 1);
    }

    public static <T extends Throwable> T sanitizeStackTrace(T throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(stackTrace.length);
        boolean skip = true;
        for (StackTraceElement element : stackTrace) {
            if (!skip) {
                list.add(element);
                continue;
            }
            if (!"kotlin.jvm.internal.Intrinsics".equals(element.getClassName()) || !METHOD_NAMES_TO_SKIP.contains(element.getMethodName())) continue;
            skip = false;
        }
        throwable.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return throwable;
    }
}

