/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.ZipFileCache;
import com.intellij.reference.SoftReference;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class JarLoader
extends Loader {
    private static final Logger LOG = Logger.getInstance(JarLoader.class);
    private final URL myURL;
    private final boolean myCanLockJar;
    private java.lang.ref.SoftReference<JarMemoryLoader> myMemoryLoader;

    JarLoader(URL url, boolean canLockJar, int index) throws IOException {
        super(new URL("jar", "", -1, url + "!/"), index);
        this.myURL = url;
        this.myCanLockJar = canLockJar;
    }

    private ZipFile acquireZipFile() throws IOException {
        String path = FileUtil.unquote(this.myURL.getFile());
        return this.myCanLockJar ? ZipFileCache.acquire(path) : new ZipFile(path);
    }

    private void releaseZipFile(ZipFile zipFile) throws IOException {
        if (this.myCanLockJar) {
            ZipFileCache.release(zipFile);
        } else if (zipFile != null) {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preloadClasses() {
        ZipFile zipFile;
        try {
            zipFile = this.acquireZipFile();
        }
        catch (Exception e) {
            LOG.debug("url: " + this.myURL, e);
            return;
        }
        try {
            try {
                JarMemoryLoader loader = JarMemoryLoader.load(zipFile, this.getBaseURL());
                if (loader != null) {
                    this.myMemoryLoader = new java.lang.ref.SoftReference<JarMemoryLoader>(loader);
                }
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildCache(ClasspathCache.LoaderData loaderData) throws IOException {
        ZipFile zipFile = this.acquireZipFile();
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                loaderData.addResourceEntry(name);
                loaderData.addNameEntry(name);
            }
        }
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        Resource resource;
        JarMemoryLoader loader = SoftReference.dereference(this.myMemoryLoader);
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile file = this.acquireZipFile();
            try {
                ZipEntry entry = file.getEntry(name);
                if (entry == null) return null;
                MemoryResource memoryResource = MemoryResource.load(this.getBaseURL(), file, entry);
                return memoryResource;
            }
            finally {
                this.releaseZipFile(file);
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return null;
    }

    public String toString() {
        return "JarLoader [" + this.myURL + "]";
    }
}

